/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.persistence.EntityManagerFactory;
import java.util.Set;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnJpaMultifactorProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.webauthn.JpaWebAuthnCredentialRegistration;
import org.apereo.cas.webauthn.JpaWebAuthnCredentialRepository;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.WebAuthn})
@AutoConfiguration
public class CasJpaWebAuthnAutoConfiguration {

    @Configuration(value="JpaWebAuthnDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JpaWebAuthnDataConfiguration {
        JpaWebAuthnDataConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"dataSourceWebAuthn"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource dataSourceWebAuthn(CasConfigurationProperties casProperties) {
            return JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getAuthn().getMfa().getWebAuthn().getJpa());
        }
    }

    @Configuration(value="JpaWebAuthnEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JpaWebAuthnEntityConfiguration {
        JpaWebAuthnEntityConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaWebAuthnVendorAdapter(@Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory, CasConfigurationProperties casProperties) {
            return jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<String> jpaWebAuthnPackagesToScan() {
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)JpaWebAuthnCredentialRegistration.class.getPackage().getName()));
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnEntityManagerFactory"})
        public FactoryBean<EntityManagerFactory> webAuthnEntityManagerFactory(@Qualifier(value="jpaWebAuthnVendorAdapter") JpaVendorAdapter jpaWebAuthnVendorAdapter, @Qualifier(value="dataSourceWebAuthn") DataSource dataSourceWebAuthn, BeanContainer<String> jpaWebAuthnPackagesToScan, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) throws Exception {
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().dataSource(dataSourceWebAuthn).packagesToScan(jpaWebAuthnPackagesToScan.toSet()).persistenceUnitName("jpaWebAuthnRegistryContext").jpaVendorAdapter(jpaWebAuthnVendorAdapter).build();
            WebAuthnJpaMultifactorProperties jpa = casProperties.getAuthn().getMfa().getWebAuthn().getJpa();
            return jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)jpa);
        }
    }

    @Configuration(value="JpaWebAuthnRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JpaWebAuthnRepositoryConfiguration {
        JpaWebAuthnRepositoryConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public WebAuthnCredentialRepository webAuthnCredentialRepository(@Qualifier(value="webAuthnTransactionTemplate") TransactionOperations webAuthnTransactionTemplate, @Qualifier(value="webAuthnCredentialRegistrationCipherExecutor") CipherExecutor webAuthnCredentialRegistrationCipherExecutor, CasConfigurationProperties casProperties) {
            return new JpaWebAuthnCredentialRepository(casProperties, (CipherExecutor<String, String>)webAuthnCredentialRegistrationCipherExecutor, webAuthnTransactionTemplate);
        }
    }

    @Configuration(value="JpaWebAuthnTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class JpaWebAuthnTransactionConfiguration {
        JpaWebAuthnTransactionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"webAuthnTransactionTemplate"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TransactionOperations webAuthnTransactionTemplate(CasConfigurationProperties casProperties, @Qualifier(value="transactionManagerWebAuthn") PlatformTransactionManager transactionManagerWebAuthn) {
            TransactionTemplate template = new TransactionTemplate(transactionManagerWebAuthn);
            template.setIsolationLevelName(casProperties.getAuthn().getMfa().getWebAuthn().getJpa().getIsolationLevelName());
            template.setPropagationBehaviorName(casProperties.getAuthn().getMfa().getWebAuthn().getJpa().getPropagationBehaviorName());
            return template;
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerWebAuthn(@Qualifier(value="webAuthnEntityManagerFactory") EntityManagerFactory emf) {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory(emf);
            return mgmr;
        }
    }
}

