/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yubico.data.CredentialRegistration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.webauthn.JpaWebAuthnCredentialRegistration;
import org.apereo.cas.webauthn.WebAuthnUtils;
import org.apereo.cas.webauthn.storage.BaseWebAuthnCredentialRepository;
import org.jooq.lambda.Unchecked;
import org.springframework.transaction.support.TransactionOperations;

public class JpaWebAuthnCredentialRepository
extends BaseWebAuthnCredentialRepository {
    private static final String UPDATE_QUERY = String.format("UPDATE %s r ", "JpaWebAuthnCredentialRegistration");
    private static final String SELECT_QUERY = String.format("SELECT r from %s r ", "JpaWebAuthnCredentialRegistration");
    private final TransactionOperations transactionTemplate;
    @PersistenceContext(unitName="jpaWebAuthnRegistryContext")
    private EntityManager entityManager;

    public JpaWebAuthnCredentialRepository(CasConfigurationProperties properties, CipherExecutor<String, String> cipherExecutor, TransactionOperations transactionTemplate) {
        super(properties, cipherExecutor);
        this.transactionTemplate = transactionTemplate;
    }

    public Collection<CredentialRegistration> getRegistrationsByUsername(String username) {
        return (Collection)this.transactionTemplate.execute(status -> {
            List records = this.entityManager.createQuery(SELECT_QUERY.concat("WHERE r.username = :username"), JpaWebAuthnCredentialRegistration.class).setParameter("username", (Object)username.trim().toLowerCase(Locale.ENGLISH)).getResultList();
            return records.stream().map(record -> (String)this.getCipherExecutor().decode((Object)record.getRecords())).map(Unchecked.function(record -> (Set)WebAuthnUtils.getObjectMapper().readValue(record, (TypeReference)new TypeReference<Set<CredentialRegistration>>(){}))).flatMap(Collection::stream).collect(Collectors.toList());
        });
    }

    public Stream<CredentialRegistration> stream() {
        List records = this.entityManager.createQuery(SELECT_QUERY, JpaWebAuthnCredentialRegistration.class).getResultList();
        return records.stream().map(record -> (String)this.getCipherExecutor().decode((Object)record.getRecords())).map(Unchecked.function(record -> (Set)WebAuthnUtils.getObjectMapper().readValue(record, (TypeReference)new TypeReference<Set<CredentialRegistration>>(){}))).flatMap(Collection::stream);
    }

    public void update(String username, Collection<CredentialRegistration> givenRecords) {
        List records = givenRecords.stream().map(record -> {
            if (record.getRegistrationTime() == null) {
                return record.withRegistrationTime(Instant.now(Clock.systemUTC()));
            }
            return record;
        }).collect(Collectors.toList());
        String jsonRecords = (String)FunctionUtils.doUnchecked(() -> (String)this.getCipherExecutor().encode((Object)WebAuthnUtils.getObjectMapper().writeValueAsString((Object)records)));
        this.transactionTemplate.executeWithoutResult(status -> {
            int count = this.entityManager.createQuery(UPDATE_QUERY.concat("SET r.records=:records WHERE r.username = :username")).setParameter("username", (Object)username.trim().toLowerCase(Locale.ENGLISH)).setParameter("records", (Object)jsonRecords).executeUpdate();
            if (count == 0) {
                Object record = ((JpaWebAuthnCredentialRegistration.JpaWebAuthnCredentialRegistrationBuilder)((JpaWebAuthnCredentialRegistration.JpaWebAuthnCredentialRegistrationBuilder)JpaWebAuthnCredentialRegistration.builder().username(username.trim().toLowerCase(Locale.ENGLISH))).records(jsonRecords)).build();
                this.entityManager.merge(record);
            }
        });
    }
}

