/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnJpaMultifactorProperties;
import org.apereo.cas.configuration.support.CasFeatureModule;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeature;
import org.apereo.cas.webauthn.JpaWebAuthnCredentialRegistration;
import org.apereo.cas.webauthn.JpaWebAuthnCredentialRepository;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(value="JpaWebAuthnConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeature(feature=CasFeatureModule.FeatureCatalog.WebAuthn)
public class JpaWebAuthnConfiguration {

    @Configuration(value="JpaWebAuthnDataConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaWebAuthnDataConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"dataSourceWebAuthn"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public DataSource dataSourceWebAuthn(CasConfigurationProperties casProperties) {
            return JpaBeans.newDataSource((AbstractJpaProperties)casProperties.getAuthn().getMfa().getWebAuthn().getJpa());
        }
    }

    @Configuration(value="JpaWebAuthnEntityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaWebAuthnEntityConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public JpaVendorAdapter jpaWebAuthnVendorAdapter(@Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory, CasConfigurationProperties casProperties) {
            return jpaBeanFactory.newJpaVendorAdapter(casProperties.getJdbc());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<String> jpaWebAuthnPackagesToScan() {
            return BeanContainer.of((Set)CollectionUtils.wrapSet((Object)JpaWebAuthnCredentialRegistration.class.getPackage().getName()));
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"webAuthnEntityManagerFactory"})
        public EntityManagerFactory webAuthnEntityManagerFactory(@Qualifier(value="jpaWebAuthnVendorAdapter") JpaVendorAdapter jpaWebAuthnVendorAdapter, @Qualifier(value="dataSourceWebAuthn") DataSource dataSourceWebAuthn, BeanContainer<String> jpaWebAuthnPackagesToScan, CasConfigurationProperties casProperties, @Qualifier(value="jpaBeanFactory") JpaBeanFactory jpaBeanFactory) throws Exception {
            JpaConfigurationContext ctx = JpaConfigurationContext.builder().dataSource(dataSourceWebAuthn).packagesToScan(jpaWebAuthnPackagesToScan.toSet()).persistenceUnitName("jpaWebAuthnRegistryContext").jpaVendorAdapter(jpaWebAuthnVendorAdapter).build();
            WebAuthnJpaMultifactorProperties jpa = casProperties.getAuthn().getMfa().getWebAuthn().getJpa();
            return (EntityManagerFactory)jpaBeanFactory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)jpa).getObject();
        }
    }

    @Configuration(value="JpaWebAuthnRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaWebAuthnRepositoryConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public WebAuthnCredentialRepository webAuthnCredentialRepository(@Qualifier(value="webAuthnCredentialRegistrationCipherExecutor") CipherExecutor webAuthnCredentialRegistrationCipherExecutor, CasConfigurationProperties casProperties, @Qualifier(value="transactionManagerWebAuthn") PlatformTransactionManager transactionManager) {
            return new JpaWebAuthnCredentialRepository(casProperties, (CipherExecutor<String, String>)webAuthnCredentialRegistrationCipherExecutor, transactionManager);
        }
    }

    @Configuration(value="JpaWebAuthnTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class JpaWebAuthnTransactionConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager transactionManagerWebAuthn(@Qualifier(value="webAuthnEntityManagerFactory") EntityManagerFactory emf) {
            JpaTransactionManager mgmr = new JpaTransactionManager();
            mgmr.setEntityManagerFactory(emf);
            return mgmr;
        }
    }
}

