/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigurationContext;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.webauthn.JpaWebAuthnCredentialRegistration;
import org.apereo.cas.webauthn.JpaWebAuthnCredentialRepository;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(value="JpaWebAuthnConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class JpaWebAuthnConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="jpaBeanFactory")
    private ObjectProvider<JpaBeanFactory> jpaBeanFactory;
    @Autowired
    @Qualifier(value="webAuthnCredentialRegistrationCipherExecutor")
    private ObjectProvider<CipherExecutor> webAuthnCredentialRegistrationCipherExecutor;

    @RefreshScope
    @Bean
    public JpaVendorAdapter jpaWebAuthnVendorAdapter() {
        return ((JpaBeanFactory)this.jpaBeanFactory.getObject()).newJpaVendorAdapter(this.casProperties.getJdbc());
    }

    @Bean
    @ConditionalOnMissingBean(name={"dataSourceWebAuthn"})
    @RefreshScope
    public DataSource dataSourceWebAuthn() {
        return JpaBeans.newDataSource((AbstractJpaProperties)this.casProperties.getAuthn().getMfa().getWebAuthn().getJpa());
    }

    @Bean
    public Set<String> jpaWebAuthnPackagesToScan() {
        return CollectionUtils.wrapSet((Object)JpaWebAuthnCredentialRegistration.class.getPackage().getName());
    }

    @Lazy
    @Bean
    @ConditionalOnMissingBean(name={"webAuthnEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean webAuthnEntityManagerFactory() {
        JpaBeanFactory factory = (JpaBeanFactory)this.jpaBeanFactory.getObject();
        JpaConfigurationContext ctx = JpaConfigurationContext.builder().dataSource(this.dataSourceWebAuthn()).packagesToScan(this.jpaWebAuthnPackagesToScan()).persistenceUnitName("jpaWebAuthnRegistryContext").jpaVendorAdapter(this.jpaWebAuthnVendorAdapter()).build();
        return factory.newEntityManagerFactoryBean(ctx, (AbstractJpaProperties)this.casProperties.getAuthn().getMfa().getWebAuthn().getJpa());
    }

    @Autowired
    @Bean
    public PlatformTransactionManager transactionManagerWebAuthn(@Qualifier(value="webAuthnEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager mgmr = new JpaTransactionManager();
        mgmr.setEntityManagerFactory(emf);
        return mgmr;
    }

    @RefreshScope
    @Bean
    public WebAuthnCredentialRepository webAuthnCredentialRepository(@Qualifier(value="transactionManagerWebAuthn") PlatformTransactionManager transactionManager) {
        return new JpaWebAuthnCredentialRepository(this.casProperties, (CipherExecutor<String, String>)((CipherExecutor)this.webAuthnCredentialRegistrationCipherExecutor.getObject()), transactionManager);
    }
}

