/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yubico.data.CredentialRegistration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.webauthn.JpaWebAuthnCredentialRegistration;
import org.apereo.cas.webauthn.WebAuthnUtils;
import org.apereo.cas.webauthn.storage.BaseWebAuthnCredentialRepository;
import org.jooq.lambda.Unchecked;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@EnableTransactionManagement(proxyTargetClass=true)
@Transactional(transactionManager="transactionManagerWebAuthn", propagation=Propagation.REQUIRED)
public class JpaWebAuthnCredentialRepository
extends BaseWebAuthnCredentialRepository {
    private static final String UPDATE_QUERY = "UPDATE JpaWebAuthnCredentialRegistration r ";
    private static final String SELECT_QUERY = "SELECT r from JpaWebAuthnCredentialRegistration r ";
    private final PlatformTransactionManager transactionManager;
    @PersistenceContext(unitName="webAuthnEntityManagerFactory")
    private transient EntityManager entityManager;

    public JpaWebAuthnCredentialRepository(CasConfigurationProperties properties, CipherExecutor<String, String> cipherExecutor, PlatformTransactionManager transactionManager) {
        super(properties, cipherExecutor);
        this.transactionManager = transactionManager;
    }

    public Collection<CredentialRegistration> getRegistrationsByUsername(String username) {
        List records = this.entityManager.createQuery(SELECT_QUERY.concat("WHERE r.username = :username"), JpaWebAuthnCredentialRegistration.class).setParameter("username", (Object)username).getResultList();
        return records.stream().map(record -> (String)this.getCipherExecutor().decode((Object)record.getRecords())).map(Unchecked.function(record -> (Set)WebAuthnUtils.getObjectMapper().readValue(record, (TypeReference)new TypeReference<Set<CredentialRegistration>>(){}))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Stream<CredentialRegistration> load() {
        List records = this.entityManager.createQuery(SELECT_QUERY, JpaWebAuthnCredentialRegistration.class).getResultList();
        return records.stream().map(record -> (String)this.getCipherExecutor().decode((Object)record.getRecords())).map(Unchecked.function(record -> (Set)WebAuthnUtils.getObjectMapper().readValue(record, (TypeReference)new TypeReference<Set<CredentialRegistration>>(){}))).flatMap(Collection::stream);
    }

    public void update(final String username, Collection<CredentialRegistration> records) {
        final String jsonRecords = (String)this.getCipherExecutor().encode((Object)WebAuthnUtils.getObjectMapper().writeValueAsString(records));
        new TransactionTemplate(this.transactionManager).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                int count = JpaWebAuthnCredentialRepository.this.entityManager.createQuery(JpaWebAuthnCredentialRepository.UPDATE_QUERY.concat("SET r.records=:records WHERE r.username = :username")).setParameter("username", (Object)username).setParameter("records", (Object)jsonRecords).executeUpdate();
                if (count == 0) {
                    Object record = ((JpaWebAuthnCredentialRegistration.JpaWebAuthnCredentialRegistrationBuilder)((JpaWebAuthnCredentialRegistration.JpaWebAuthnCredentialRegistrationBuilder)JpaWebAuthnCredentialRegistration.builder().username(username)).records(jsonRecords)).build();
                    JpaWebAuthnCredentialRepository.this.entityManager.merge(record);
                }
            }
        });
    }
}

