/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FRedisMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.redis.core.CasRedisTemplate;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.u2f.redis.U2FRedisDeviceRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.U2F}, module="redis")
@AutoConfiguration
public class U2FRedisConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.mfa.u2f.redis.enabled").isTrue().evenIfMissing();

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"u2fRedisTemplate"})
    public CasRedisTemplate u2fRedisTemplate(ConfigurableApplicationContext applicationContext, @Qualifier(value="u2fRedisConnectionFactory") RedisConnectionFactory u2fRedisConnectionFactory) throws Exception {
        return (CasRedisTemplate)BeanSupplier.of(CasRedisTemplate.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)u2fRedisConnectionFactory)).otherwiseProxy().get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"u2fRedisConnectionFactory"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RedisConnectionFactory u2fRedisConnectionFactory(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSslContext") CasSSLContext casSslContext, CasConfigurationProperties casProperties) throws Exception {
        return (RedisConnectionFactory)BeanSupplier.of(RedisConnectionFactory.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            U2FRedisMultifactorAuthenticationProperties redis = casProperties.getAuthn().getMfa().getU2f().getRedis();
            return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis, (CasSSLContext)casSslContext);
        }).otherwiseProxy().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public U2FDeviceRepository u2fDeviceRepository(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="u2fRedisTemplate") CasRedisTemplate u2fRedisTemplate, @Qualifier(value="u2fRegistrationRecordCipherExecutor") CipherExecutor u2fRegistrationRecordCipherExecutor) throws Exception {
        return (U2FDeviceRepository)BeanSupplier.of(U2FDeviceRepository.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
            LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getCore().getExpireRegistrations(), u2f.getCore().getExpireRegistrationsTimeUnit()).build(key -> "");
            return new U2FRedisDeviceRepository((LoadingCache<String, String>)requestStorage, (CasRedisTemplate<String, U2FDeviceRegistration>)u2fRedisTemplate, (CipherExecutor<Serializable, String>)u2fRegistrationRecordCipherExecutor, casProperties);
        }).otherwiseProxy().get();
    }
}

