/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FRedisMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.u2f.redis.U2FRedisDeviceRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.authn.mfa.u2f.redis", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Configuration(value="U2fRedisConfiguration", proxyBeanMethods=false)
public class U2FRedisConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"u2fRedisTemplate"})
    public RedisTemplate u2fRedisTemplate(@Qualifier(value="u2fRedisConnectionFactory") RedisConnectionFactory u2fRedisConnectionFactory) {
        return RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)u2fRedisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(name={"u2fRedisConnectionFactory"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RedisConnectionFactory u2fRedisConnectionFactory(@Qualifier(value="casSslContext") CasSSLContext casSslContext, CasConfigurationProperties casProperties) {
        U2FRedisMultifactorAuthenticationProperties redis = casProperties.getAuthn().getMfa().getU2f().getRedis();
        return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis, (CasSSLContext)casSslContext);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public U2FDeviceRepository u2fDeviceRepository(CasConfigurationProperties casProperties, @Qualifier(value="u2fRedisTemplate") RedisTemplate u2fRedisTemplate, @Qualifier(value="u2fRegistrationRecordCipherExecutor") CipherExecutor u2fRegistrationRecordCipherExecutor) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getCore().getExpireRegistrations(), u2f.getCore().getExpireRegistrationsTimeUnit()).build(key -> "");
        return new U2FRedisDeviceRepository((LoadingCache<String, String>)requestStorage, (RedisTemplate<String, U2FDeviceRegistration>)u2fRedisTemplate, u2f.getCore().getExpireDevices(), u2f.getCore().getExpireDevicesTimeUnit(), (CipherExecutor<Serializable, String>)u2fRegistrationRecordCipherExecutor);
    }
}

