/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FRedisMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.u2f.redis.U2FRedisDeviceRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration(value="u2fRedisConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnProperty(prefix="cas.authn.mfa.u2f.redis", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class U2FRedisConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="u2fRegistrationRecordCipherExecutor")
    private ObjectProvider<CipherExecutor> u2fRegistrationRecordCipherExecutor;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"u2fRedisTemplate"})
    public RedisTemplate u2fRedisTemplate() {
        return RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)this.u2fRedisConnectionFactory());
    }

    @Bean
    @ConditionalOnMissingBean(name={"u2fRedisConnectionFactory"})
    @RefreshScope
    public RedisConnectionFactory u2fRedisConnectionFactory() {
        U2FRedisMultifactorAuthenticationProperties redis = this.casProperties.getAuthn().getMfa().getU2f().getRedis();
        return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis);
    }

    @Bean
    @RefreshScope
    public U2FDeviceRepository u2fDeviceRepository() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getCore().getExpireRegistrations(), u2f.getCore().getExpireRegistrationsTimeUnit()).build(key -> "");
        return new U2FRedisDeviceRepository((LoadingCache<String, String>)requestStorage, (RedisTemplate<String, U2FDeviceRegistration>)this.u2fRedisTemplate(), u2f.getCore().getExpireDevices(), u2f.getCore().getExpireDevicesTimeUnit(), (CipherExecutor<Serializable, String>)((CipherExecutor)this.u2fRegistrationRecordCipherExecutor.getObject()));
    }
}

