/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.u2f.redis;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class U2FRedisDeviceRepository
extends BaseU2FDeviceRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FRedisDeviceRepository.class);
    public static final String CAS_U2F_PREFIX = U2FRedisDeviceRepository.class.getSimpleName() + ":";
    private final transient RedisTemplate<String, U2FDeviceRegistration> redisTemplate;
    private final long expirationTime;
    private final TimeUnit expirationTimeUnit;

    public U2FRedisDeviceRepository(LoadingCache<String, String> requestStorage, RedisTemplate<String, U2FDeviceRegistration> redisTemplate, long expirationTime, TimeUnit expirationTimeUnit, CipherExecutor<Serializable, String> cipherExecutor) {
        super(requestStorage, cipherExecutor);
        this.expirationTime = expirationTime;
        this.expirationTimeUnit = expirationTimeUnit;
        this.redisTemplate = redisTemplate;
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices() {
        LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
        Set keys = this.redisTemplate.keys((Object)U2FRedisDeviceRepository.getPatternRedisKey());
        if (keys != null) {
            return this.queryDeviceRegistrations(expirationDate, keys);
        }
        return new ArrayList(0);
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices(String username) {
        LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
        Set keys = this.redisTemplate.keys((Object)U2FRedisDeviceRepository.buildRedisKeyForUser(username));
        if (keys != null) {
            return this.queryDeviceRegistrations(expirationDate, keys);
        }
        return new ArrayList(0);
    }

    public U2FDeviceRegistration registerDevice(U2FDeviceRegistration record) {
        String redisKey = U2FRedisDeviceRepository.buildRedisKeyForRecord(record);
        this.redisTemplate.boundValueOps((Object)redisKey).set((Object)record);
        return (U2FDeviceRegistration)this.redisTemplate.boundValueOps((Object)redisKey).get();
    }

    public boolean isDeviceRegisteredFor(String username) {
        return !this.getRegisteredDevices(username).isEmpty();
    }

    public void clean() {
        LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
        LOGGER.debug("Cleaning up expired U2F device registrations based on expiration date [{}]", (Object)expirationDate);
        List expiredKeys = this.getRedisKeys().stream().map(redisKey -> (U2FDeviceRegistration)this.redisTemplate.boundValueOps(redisKey).get()).filter(Objects::nonNull).map(U2FDeviceRegistration.class::cast).filter(audit -> audit.getCreatedDate().compareTo(expirationDate) <= 0).map(U2FRedisDeviceRepository::buildRedisKeyForRecord).collect(Collectors.toList());
        this.redisTemplate.delete(expiredKeys);
    }

    public void removeAll() {
        this.redisTemplate.delete(this.getRedisKeys());
    }

    public void deleteRegisteredDevice(U2FDeviceRegistration record) {
        String redisKey = U2FRedisDeviceRepository.buildRedisKeyForRecord(record);
        this.redisTemplate.delete((Object)redisKey);
    }

    private static String getPatternRedisKey() {
        return CAS_U2F_PREFIX + "*";
    }

    private static String buildRedisKeyForRecord(U2FDeviceRegistration record) {
        return CAS_U2F_PREFIX + record.getUsername() + ":" + record.getId();
    }

    private static String buildRedisKeyForUser(String username) {
        return CAS_U2F_PREFIX + username + ":*";
    }

    private Collection<? extends U2FDeviceRegistration> queryDeviceRegistrations(LocalDate expirationDate, Set<String> keys) {
        return keys.stream().map(redisKey -> (U2FDeviceRegistration)this.redisTemplate.boundValueOps(redisKey).get()).filter(Objects::nonNull).map(U2FDeviceRegistration.class::cast).filter(audit -> audit.getCreatedDate().compareTo(expirationDate) >= 0).collect(Collectors.toList());
    }

    private Set<String> getRedisKeys() {
        return this.redisTemplate.keys((Object)U2FRedisDeviceRepository.getPatternRedisKey());
    }
}

