/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.u2f.redis;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.yubico.u2f.data.DeviceRegistration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class U2FRedisDeviceRepository
extends BaseU2FDeviceRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FRedisDeviceRepository.class);
    public static final String CAS_U2F_PREFIX = U2FRedisDeviceRepository.class.getSimpleName() + ":";
    private final transient RedisTemplate redisTemplate;
    private final long expirationTime;
    private final TimeUnit expirationTimeUnit;

    public U2FRedisDeviceRepository(LoadingCache<String, String> requestStorage, RedisTemplate redisTemplate, long expirationTime, TimeUnit expirationTimeUnit) {
        super(requestStorage);
        this.expirationTime = expirationTime;
        this.expirationTimeUnit = expirationTimeUnit;
        this.redisTemplate = redisTemplate;
    }

    public Collection<? extends DeviceRegistration> getRegisteredDevices(String username) {
        try {
            LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
            Set keys = this.redisTemplate.keys((Object)U2FRedisDeviceRepository.buildRedisKeyForUser(username));
            if (keys != null) {
                return keys.stream().map(redisKey -> this.redisTemplate.boundValueOps(redisKey).get()).filter(Objects::nonNull).map(U2FDeviceRegistration.class::cast).filter(audit -> audit.getCreatedDate().compareTo(expirationDate) >= 0).map(r -> {
                    try {
                        String decoded = (String)this.getCipherExecutor().decode((Object)r.getRecord());
                        if (StringUtils.isNotBlank((CharSequence)decoded)) {
                            return DeviceRegistration.fromJson((String)decoded);
                        }
                        LOGGER.warn("Unable to to decode device registration for record id [{}]", (Object)r.getId());
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList(0);
    }

    public void registerDevice(String username, DeviceRegistration registration) {
        this.authenticateDevice(username, registration);
    }

    public void authenticateDevice(String username, DeviceRegistration registration) {
        U2FDeviceRegistration record = new U2FDeviceRegistration();
        record.setUsername(username);
        record.setRecord((String)this.getCipherExecutor().encode((Object)registration.toJson()));
        record.setCreatedDate(LocalDate.now(ZoneId.systemDefault()));
        String redisKey = U2FRedisDeviceRepository.buildRedisKeyForRecord(record);
        this.redisTemplate.boundValueOps((Object)redisKey).set((Object)record);
    }

    public boolean isDeviceRegisteredFor(String username) {
        return !this.getRegisteredDevices(username).isEmpty();
    }

    public void clean() {
        try {
            LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
            LOGGER.debug("Cleaning up expired U2F device registrations based on expiration date [{}]", (Object)expirationDate);
            List expiredKeys = this.getRedisKeys().stream().map(redisKey -> this.redisTemplate.boundValueOps(redisKey).get()).filter(Objects::nonNull).map(U2FDeviceRegistration.class::cast).filter(audit -> audit.getCreatedDate().compareTo(expirationDate) <= 0).map(U2FRedisDeviceRepository::buildRedisKeyForRecord).collect(Collectors.toList());
            this.redisTemplate.delete(expiredKeys);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeAll() {
        Set keys = this.redisTemplate.keys(this.getRedisKeys());
        if (keys != null) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    private static String getPatternRedisKey() {
        return CAS_U2F_PREFIX + "*";
    }

    private Set<String> getRedisKeys() {
        return this.redisTemplate.keys((Object)U2FRedisDeviceRepository.getPatternRedisKey());
    }

    private static String buildRedisKeyForRecord(U2FDeviceRegistration record) {
        return CAS_U2F_PREFIX + record.getUsername() + ":" + record.getId();
    }

    private static String buildRedisKeyForUser(String username) {
        return CAS_U2F_PREFIX + username + ":*";
    }
}

