/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FMongoDbDeviceRepository;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMongoDbMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.mongo.CasMongoOperations;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.mongodb.core.MongoOperations;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.U2F, module="mongo")
@AutoConfiguration
public class U2FMongoDbConfiguration {
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public U2FDeviceRepository u2fDeviceRepository(CasConfigurationProperties casProperties, @Qualifier(value="u2fRegistrationRecordCipherExecutor") CipherExecutor u2fRegistrationRecordCipherExecutor, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
        U2FMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory(casSslContext.getSslContext());
        U2FMongoDbMultifactorAuthenticationProperties mongoProps = u2f.getMongo();
        CasMongoOperations mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongoProps);
        MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongoProps.getCollection(), (boolean)mongoProps.isDropCollection());
        LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getCore().getExpireRegistrations(), u2f.getCore().getExpireRegistrationsTimeUnit()).build(key -> "");
        return new U2FMongoDbDeviceRepository((LoadingCache<String, String>)requestStorage, (MongoOperations)mongoTemplate, (CipherExecutor<Serializable, String>)u2fRegistrationRecordCipherExecutor, casProperties);
    }
}

