/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class U2FMongoDbDeviceRepository
extends BaseU2FDeviceRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FMongoDbDeviceRepository.class);
    private final transient MongoTemplate mongoTemplate;

    public U2FMongoDbDeviceRepository(LoadingCache<String, String> requestStorage, MongoTemplate mongoTemplate, CipherExecutor<Serializable, String> cipherExecutor, CasConfigurationProperties casProperties) {
        super(casProperties, requestStorage, cipherExecutor);
        this.mongoTemplate = mongoTemplate;
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices(String username) {
        LocalDate expirationDate = this.getDeviceExpiration();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)username).and("createdDate").gte((Object)expirationDate));
        return this.queryDeviceRegistrations(query);
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices() {
        LocalDate expirationDate = this.getDeviceExpiration();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdDate").gte((Object)expirationDate));
        return this.queryDeviceRegistrations(query);
    }

    public U2FDeviceRegistration registerDevice(U2FDeviceRegistration registration) {
        return (U2FDeviceRegistration)this.mongoTemplate.save((Object)registration, this.casProperties.getAuthn().getMfa().getU2f().getMongo().getCollection());
    }

    public void deleteRegisteredDevice(U2FDeviceRegistration record) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)record.getUsername()).and("id").is((Object)record.getId()));
        this.mongoTemplate.remove(query, U2FDeviceRegistration.class, this.casProperties.getAuthn().getMfa().getU2f().getMongo().getCollection());
    }

    public boolean isDeviceRegisteredFor(String username) {
        return !this.getRegisteredDevices(username).isEmpty();
    }

    public void clean() {
        LocalDate expirationDate = this.getDeviceExpiration();
        LOGGER.debug("Cleaning up expired U2F device registrations based on expiration date [{}]", (Object)expirationDate);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdDate").lte((Object)expirationDate));
        this.mongoTemplate.remove(query, U2FDeviceRegistration.class, this.casProperties.getAuthn().getMfa().getU2f().getMongo().getCollection());
    }

    public void removeAll() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdDate").exists(true));
        this.mongoTemplate.remove(query, U2FDeviceRegistration.class, this.casProperties.getAuthn().getMfa().getU2f().getMongo().getCollection());
    }

    private Collection<? extends U2FDeviceRegistration> queryDeviceRegistrations(Query query) {
        return this.mongoTemplate.find(query, U2FDeviceRegistration.class, this.casProperties.getAuthn().getMfa().getU2f().getMongo().getCollection()).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

