/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FMongoDbDeviceRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMongoDbMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration(value="u2fMongoDbConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class U2FMongoDbConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="u2fRegistrationRecordCipherExecutor")
    private ObjectProvider<CipherExecutor> u2fRegistrationRecordCipherExecutor;
    @Autowired
    @Qualifier(value="sslContext")
    private ObjectProvider<SSLContext> sslContext;

    @Bean
    @RefreshScope
    public U2FDeviceRepository u2fDeviceRepository() {
        U2FMultifactorAuthenticationProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory((SSLContext)this.sslContext.getObject());
        U2FMongoDbMultifactorAuthenticationProperties mongoProps = u2f.getMongo();
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongoProps);
        MongoDbConnectionFactory.createCollection((MongoOperations)mongoTemplate, (String)mongoProps.getCollection(), (boolean)mongoProps.isDropCollection());
        LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getCore().getExpireRegistrations(), u2f.getCore().getExpireRegistrationsTimeUnit()).build(key -> "");
        return new U2FMongoDbDeviceRepository((LoadingCache<String, String>)requestStorage, mongoTemplate, u2f.getCore().getExpireDevices(), u2f.getCore().getExpireDevicesTimeUnit(), mongoProps.getCollection(), (CipherExecutor<Serializable, String>)((CipherExecutor)this.u2fRegistrationRecordCipherExecutor.getObject()));
    }
}

