/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class U2FMongoDbDeviceRepository
extends BaseU2FDeviceRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FMongoDbDeviceRepository.class);
    private final transient MongoTemplate mongoTemplate;
    private final long expirationTime;
    private final TimeUnit expirationTimeUnit;
    private final String collectionName;

    public U2FMongoDbDeviceRepository(LoadingCache<String, String> requestStorage, MongoTemplate mongoTemplate, long expirationTime, TimeUnit expirationTimeUnit, String collectionName, CipherExecutor<Serializable, String> cipherExecutor) {
        super(requestStorage, cipherExecutor);
        this.expirationTime = expirationTime;
        this.expirationTimeUnit = expirationTimeUnit;
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices() {
        try {
            LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdDate").gte((Object)expirationDate));
            return this.queryDeviceRegistrations(query);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new ArrayList(0);
        }
    }

    public Collection<? extends U2FDeviceRegistration> getRegisteredDevices(String username) {
        try {
            LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)username).and("createdDate").gte((Object)expirationDate));
            return this.queryDeviceRegistrations(query);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new ArrayList(0);
        }
    }

    public U2FDeviceRegistration registerDevice(U2FDeviceRegistration registration) {
        return (U2FDeviceRegistration)this.mongoTemplate.save((Object)registration, this.collectionName);
    }

    public boolean isDeviceRegisteredFor(String username) {
        return !this.getRegisteredDevices(username).isEmpty();
    }

    public void clean() {
        try {
            LocalDate expirationDate = LocalDate.now(ZoneId.systemDefault()).minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
            LOGGER.debug("Cleaning up expired U2F device registrations based on expiration date [{}]", (Object)expirationDate);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdDate").lte((Object)expirationDate));
            this.mongoTemplate.remove(query, U2FDeviceRegistration.class, this.collectionName);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    public void removeAll() {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdDate").exists(true));
            this.mongoTemplate.remove(query, U2FDeviceRegistration.class, this.collectionName);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    public void deleteRegisteredDevice(U2FDeviceRegistration record) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)record.getUsername()).and("id").is((Object)record.getId()));
            this.mongoTemplate.remove(query, U2FDeviceRegistration.class, this.collectionName);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    private Collection<? extends U2FDeviceRegistration> queryDeviceRegistrations(Query query) {
        return this.mongoTemplate.find(query, U2FDeviceRegistration.class, this.collectionName).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

