/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.yubico.u2f.data.DeviceRegistration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.u2f.storage.BaseU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class U2FMongoDbDeviceRepository
extends BaseU2FDeviceRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(U2FMongoDbDeviceRepository.class);
    private final transient MongoTemplate mongoTemplate;
    private final long expirationTime;
    private final TimeUnit expirationTimeUnit;
    private final String collectionName;

    public U2FMongoDbDeviceRepository(LoadingCache<String, String> requestStorage, MongoTemplate mongoTemplate, long expirationTime, TimeUnit expirationTimeUnit, String collectionName) {
        super(requestStorage);
        this.expirationTime = expirationTime;
        this.expirationTimeUnit = expirationTimeUnit;
        this.mongoTemplate = mongoTemplate;
        this.collectionName = collectionName;
    }

    public Collection<? extends DeviceRegistration> getRegisteredDevices(String username) {
        try {
            LocalDate expirationDate = LocalDate.now().minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"username").is((Object)username).and("createdDate").gte((Object)expirationDate));
            return this.mongoTemplate.find(query, U2FDeviceRegistration.class, this.collectionName).stream().map(r -> {
                try {
                    return DeviceRegistration.fromJson((String)((String)this.getCipherExecutor().decode((Object)r.getRecord())));
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ArrayList(0);
        }
    }

    public void registerDevice(String username, DeviceRegistration registration) {
        this.authenticateDevice(username, registration);
    }

    public void authenticateDevice(String username, DeviceRegistration registration) {
        U2FDeviceRegistration record = new U2FDeviceRegistration();
        record.setUsername(username);
        record.setRecord((String)this.getCipherExecutor().encode((Object)registration.toJson()));
        record.setCreatedDate(LocalDate.now());
        this.mongoTemplate.save((Object)record, this.collectionName);
    }

    public boolean isDeviceRegisteredFor(String username) {
        return !this.getRegisteredDevices(username).isEmpty();
    }

    public void clean() {
        try {
            LocalDate expirationDate = LocalDate.now().minus(this.expirationTime, DateTimeUtils.toChronoUnit((TimeUnit)this.expirationTimeUnit));
            LOGGER.debug("Cleaning up expired U2F device registrations based on expiration date [{}]", (Object)expirationDate);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdDate").lte((Object)expirationDate));
            this.mongoTemplate.remove(query, U2FDeviceRegistration.class, this.collectionName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeAll() {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"createdDate").exists(true));
            this.mongoTemplate.remove(query, U2FDeviceRegistration.class, this.collectionName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

