/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FMongoDbDeviceRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.U2FMultifactorProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration(value="u2fMongoDbConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class U2FMongoDbConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public U2FDeviceRepository u2fDeviceRepository() {
        U2FMultifactorProperties u2f = this.casProperties.getAuthn().getMfa().getU2f();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory();
        U2FMultifactorProperties.MongoDb mongoProps = u2f.getMongo();
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)mongoProps);
        factory.createCollection((MongoOperations)mongoTemplate, mongoProps.getCollection(), mongoProps.isDropCollection());
        LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getExpireRegistrations(), u2f.getExpireRegistrationsTimeUnit()).build(key -> "");
        return new U2FMongoDbDeviceRepository((LoadingCache<String, String>)requestStorage, mongoTemplate, u2f.getExpireRegistrations(), u2f.getExpireDevicesTimeUnit(), mongoProps.getCollection());
    }
}

