/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import org.apereo.cas.support.spnego.authentication.handler.support.JcifsConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ResourceLoader;

@Tag(value="Spnego")
public class JcifsConfigTests {
    @Test
    public void verifyKerbSysConfig() throws Exception {
        final StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        String path = new ClassPathResource("kerb5.conf").getFile().getCanonicalPath();
        final String loginConf = new ClassPathResource("jaas.conf").getFile().getCanonicalPath();
        final JcifsConfig.SystemSettings settings = new JcifsConfig.SystemSettings();
        JcifsConfig.SystemSettings.setKerberosDebug((String)"true");
        JcifsConfig.SystemSettings.setKerberosConf((String)("file:" + path));
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                JcifsConfig.SystemSettings.initialize((ResourceLoader)applicationContext, (String)("file:" + loginConf));
            }
        });
    }

    @Test
    public void verifyJcifsConfig() {
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                JcifsConfig.JcifsSettings settings = new JcifsConfig.JcifsSettings();
                settings.setJcifsDomain("DOMAIN");
                settings.setJcifsDomainController("CONTROLLER");
                settings.setJcifsNetbiosCachePolicy(1000L);
                settings.setJcifsPassword("PASS");
                settings.setJcifsServicePassword("P@$$");
                settings.setJcifsServicePrincipal("EXAMPLE/Principal");
                settings.setJcifsSocketTimeout(100L);
                settings.setJcifsUsername("Principal");
            }
        });
    }
}

