/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import com.google.common.base.Splitter;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import javax.security.auth.login.FailedLoginException;
import jcifs.spnego.Authentication;
import jcifs.spnego.AuthenticationException;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.spnego.SpnegoProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class JcifsSpnegoAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JcifsSpnegoAuthenticationHandler.class);
    private final BlockingQueue<List<Authentication>> authenticationsPool;
    private final boolean principalWithDomainName;
    private final boolean ntlmAllowed;
    private final long poolTimeoutInMilliseconds;

    public JcifsSpnegoAuthenticationHandler(SpnegoProperties spnegoProperties, ServicesManager servicesManager, PrincipalFactory principalFactory, BlockingQueue<List<Authentication>> authenticationsPool) {
        super(spnegoProperties.getName(), servicesManager, principalFactory, Integer.valueOf(spnegoProperties.getOrder()));
        this.authenticationsPool = authenticationsPool;
        this.principalWithDomainName = spnegoProperties.isPrincipalWithDomainName();
        this.ntlmAllowed = spnegoProperties.isNtlmAllowed();
        this.poolTimeoutInMilliseconds = Beans.newDuration((String)spnegoProperties.getPoolTimeout()).toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws Throwable {
        AuthenticationHandlerExecutionResult authenticationHandlerExecutionResult;
        SpnegoCredential spnegoCredential = (SpnegoCredential)credential;
        if (!this.ntlmAllowed && spnegoCredential.isNtlm()) {
            throw new FailedLoginException("NTLM not allowed");
        }
        LOGGER.debug("Waiting for connection to validate SPNEGO Token");
        List<Authentication> authentications = this.authenticationsPool.poll(this.poolTimeoutInMilliseconds, TimeUnit.MILLISECONDS);
        if (authentications == null) throw new FailedLoginException("Cannot get connection from pool to validate SPNEGO Token");
        try {
            authenticationHandlerExecutionResult = this.doInternalAuthentication(authentications, spnegoCredential, service);
            this.authenticationsPool.add(authentications);
        }
        catch (Throwable throwable) {
            try {
                this.authenticationsPool.add(authentications);
                LOGGER.debug("Returned connection to pool");
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new FailedLoginException("Thread interrupted while waiting for connection to validate SPNEGO Token");
            }
        }
        LOGGER.debug("Returned connection to pool");
        return authenticationHandlerExecutionResult;
    }

    protected AuthenticationHandlerExecutionResult doInternalAuthentication(List<Authentication> authentications, SpnegoCredential spnegoCredential, Service service) throws Throwable {
        Principal principal = null;
        byte[] nextToken = null;
        Iterator<Authentication> it = authentications.iterator();
        while (nextToken == null && it.hasNext()) {
            try {
                Authentication authentication = it.next();
                authentication.reset();
                LOGGER.debug("Processing SPNEGO authentication");
                authentication.process(spnegoCredential.getInitToken());
                principal = authentication.getPrincipal();
                LOGGER.debug("Authenticated SPNEGO principal [{}]. Retrieving the next token for authentication...", Optional.ofNullable(principal).map(Principal::getName).orElse(null));
                nextToken = authentication.getNextToken();
            }
            catch (AuthenticationException e) {
                LOGGER.debug("Processing SPNEGO authentication failed with exception", (Throwable)e);
                throw new FailedLoginException(e.getMessage());
            }
        }
        if (nextToken != null) {
            LOGGER.debug("Setting nextToken in credential");
            spnegoCredential.setNextToken(nextToken);
        } else {
            LOGGER.debug("nextToken is null");
        }
        boolean success = false;
        if (principal != null) {
            if (spnegoCredential.isNtlm()) {
                LOGGER.debug("NTLM Credential is valid for user [{}]", (Object)principal.getName());
            } else {
                LOGGER.debug("Kerberos Credential is valid for user [{}]", (Object)principal.getName());
            }
            spnegoCredential.setPrincipal(this.getPrincipal(principal.getName(), spnegoCredential.isNtlm()));
            success = true;
        }
        if (!success) {
            throw new FailedLoginException("Principal is null, the processing of the SPNEGO Token failed");
        }
        return new DefaultAuthenticationHandlerExecutionResult((AuthenticationHandler)this, (Credential)spnegoCredential, spnegoCredential.getPrincipal());
    }

    public boolean supports(Credential credential) {
        return credential instanceof SpnegoCredential;
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return SpnegoCredential.class.isAssignableFrom(clazz);
    }

    protected org.apereo.cas.authentication.principal.Principal getPrincipal(String name, boolean isNtlm) throws Throwable {
        if (this.principalWithDomainName) {
            return this.principalFactory.createPrincipal(name);
        }
        if (isNtlm) {
            List splitList;
            if (Pattern.matches("\\S+\\\\\\S+", name) && (splitList = Splitter.on((Pattern)Pattern.compile("\\\\")).splitToList((CharSequence)name)).size() == 2) {
                return this.principalFactory.createPrincipal((String)splitList.get(1));
            }
            return this.principalFactory.createPrincipal(name);
        }
        List splitList = Splitter.on((String)"@").splitToList((CharSequence)name);
        return this.principalFactory.createPrincipal((String)splitList.getFirst());
    }
}

