/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.principal;

import java.util.Optional;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoPrincipalResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@Tag(value="Spnego")
class SpnegoCredentialsToPrincipalResolverTests {
    private SpnegoPrincipalResolver resolver;
    private SpnegoCredential spnegoCredentials;
    @Mock
    private ServicesManager servicesManager;
    @Mock
    private AttributeDefinitionStore attributeDefinitionStore;

    SpnegoCredentialsToPrincipalResolverTests() {
    }

    @BeforeEach
    public void initialize() throws Exception {
        MockitoAnnotations.openMocks((Object)this).close();
        PrincipalResolutionContext context = PrincipalResolutionContext.builder().servicesManager(this.servicesManager).attributeDefinitionStore(this.attributeDefinitionStore).attributeMerger(CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)PrincipalAttributesCoreProperties.MergingStrategyTypes.REPLACE)).attributeRepository((IPersonAttributeDao)CoreAuthenticationTestUtils.getAttributeRepository()).principalFactory(PrincipalFactoryUtils.newPrincipalFactory()).returnNullIfNoAttributes(false).principalNameTransformer(formUserId -> formUserId).useCurrentPrincipalId(false).resolveAttributes(true).activeAttributeRepositoryIdentifiers(CollectionUtils.wrapSet((Object)"*")).build();
        this.resolver = new SpnegoPrincipalResolver(context);
        this.spnegoCredentials = new SpnegoCredential(new byte[]{0, 1, 2});
    }

    @Test
    void verifyValidCredentials() throws Throwable {
        this.spnegoCredentials.setPrincipal(PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("test"));
        Assertions.assertEquals((Object)"test", (Object)this.resolver.resolve((Credential)this.spnegoCredentials, Optional.of(CoreAuthenticationTestUtils.getPrincipal()), Optional.of(new SimpleTestUsernamePasswordAuthenticationHandler()), Optional.of(CoreAuthenticationTestUtils.getService())).getId());
    }

    @Test
    void verifySupports() throws Throwable {
        Assertions.assertFalse((boolean)this.resolver.supports(null));
        Assertions.assertTrue((boolean)this.resolver.supports((Credential)this.spnegoCredentials));
        Assertions.assertFalse((boolean)this.resolver.supports((Credential)new UsernamePasswordCredential()));
    }
}

