/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import org.apereo.cas.support.spnego.authentication.handler.support.JcifsConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ResourceLoader;

@Tag(value="Spnego")
public class JcifsConfigTests {
    @Test
    public void verifyKerbSysConfig() throws Exception {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.refresh();
        String path = new ClassPathResource("kerb5.conf").getFile().getCanonicalPath();
        String loginConf = new ClassPathResource("jaas.conf").getFile().getCanonicalPath();
        JcifsConfig.SystemSettings settings = new JcifsConfig.SystemSettings();
        JcifsConfig.SystemSettings.setKerberosDebug((String)"true");
        JcifsConfig.SystemSettings.setKerberosConf((String)("file:" + path));
        Assertions.assertDoesNotThrow(() -> JcifsConfig.SystemSettings.initialize((ResourceLoader)applicationContext, (String)("file:" + loginConf)));
    }

    @Test
    public void verifyJcifsConfig() {
        Assertions.assertDoesNotThrow(() -> {
            JcifsConfig.JcifsSettings settings = new JcifsConfig.JcifsSettings();
            settings.setJcifsDomain("DOMAIN");
            settings.setJcifsDomainController("CONTROLLER");
            settings.setJcifsNetbiosCachePolicy(1000L);
            settings.setJcifsPassword("PASS");
            settings.setJcifsServicePassword("P@$$");
            settings.setJcifsServicePrincipal("EXAMPLE/Principal");
            settings.setJcifsSocketTimeout(100L);
            settings.setJcifsUsername("Principal");
        });
    }
}

