/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.principal;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Spnego")
public class SpnegoCredentialsTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    @Test
    public void verifyToStringWithNoPrincipal() {
        SpnegoCredential credentials = new SpnegoCredential(ArrayUtils.EMPTY_BYTE_ARRAY);
        Assertions.assertTrue((boolean)credentials.getId().contains("unknown"));
    }

    @Test
    public void verifyToStringWithPrincipal() {
        SpnegoCredential credentials = new SpnegoCredential(ArrayUtils.EMPTY_BYTE_ARRAY);
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("test");
        credentials.setPrincipal(principal);
        Assertions.assertEquals((Object)"test", (Object)credentials.getId());
    }

    @Test
    public void verifyPrincipalAffectsHash() {
        SpnegoCredential credential = new SpnegoCredential(ArrayUtils.EMPTY_BYTE_ARRAY);
        int hash1 = credential.hashCode();
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("test");
        credential.setPrincipal(principal);
        int hash2 = credential.hashCode();
        Assertions.assertNotEquals((int)hash1, (int)hash2);
    }

    @Test
    public void verifyToStringWithToken() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[16]);
        credentials.setNextToken(new byte[16]);
        Assertions.assertFalse((boolean)MAPPER.writeValueAsString((Object)credentials).contains("initToken"));
        Assertions.assertFalse((boolean)MAPPER.writeValueAsString((Object)credentials).contains("nextToken"));
    }

    @Test
    public void verifyJsonWithToken() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[16]);
        credentials.setNextToken(new byte[16]);
        Assertions.assertFalse((boolean)MAPPER.writeValueAsString((Object)credentials).contains("initToken"));
        Assertions.assertFalse((boolean)MAPPER.writeValueAsString((Object)credentials).contains("nextToken"));
    }
}

