/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import jcifs.spnego.Authentication;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.support.ntlm.NtlmProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoSystemProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsConfig;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.handler.support.NtlmAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoPrincipalResolver;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.BeanContainer;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Configuration(value="SpnegoConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SpnegoConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"spnegoAuthentications"})
    public BeanContainer<Authentication> spnegoAuthentications(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        SpnegoSystemProperties spnegoSystem = casProperties.getAuthn().getSpnego().getSystem();
        JcifsConfig.SystemSettings.initialize((ResourceLoader)applicationContext, spnegoSystem.getLoginConf());
        if (ResourceUtils.doesResourceExist((String)spnegoSystem.getKerberosConf())) {
            Resource kerbConf = applicationContext.getResource(spnegoSystem.getKerberosConf());
            FunctionUtils.doAndIgnore(o -> JcifsConfig.SystemSettings.setKerberosConf(kerbConf.getFile().getCanonicalPath()), (Object[])new Object[0]);
        }
        JcifsConfig.SystemSettings.setKerberosDebug(spnegoSystem.getKerberosDebug());
        JcifsConfig.SystemSettings.setKerberosKdc(spnegoSystem.getKerberosKdc());
        JcifsConfig.SystemSettings.setKerberosRealm(spnegoSystem.getKerberosRealm());
        JcifsConfig.SystemSettings.setUseSubjectCredsOnly(spnegoSystem.isUseSubjectCredsOnly());
        List props = casProperties.getAuthn().getSpnego().getProperties();
        return BeanContainer.of(props.stream().map(p -> {
            JcifsConfig c = new JcifsConfig();
            JcifsConfig.JcifsSettings jcifsSettings = c.getJcifsSettings();
            jcifsSettings.setJcifsDomain(p.getJcifsDomain());
            jcifsSettings.setJcifsDomainController(p.getJcifsDomainController());
            jcifsSettings.setJcifsNetbiosCachePolicy(p.getCachePolicy());
            jcifsSettings.setJcifsNetbiosWins(p.getJcifsNetbiosWins());
            jcifsSettings.setJcifsPassword(p.getJcifsPassword());
            jcifsSettings.setJcifsServicePassword(p.getJcifsServicePassword());
            jcifsSettings.setJcifsServicePrincipal(p.getJcifsServicePrincipal());
            jcifsSettings.setJcifsSocketTimeout(Beans.newDuration((String)p.getTimeout()).toMillis());
            jcifsSettings.setJcifsUsername(p.getJcifsUsername());
            return new Authentication(jcifsSettings.getProperties());
        }).collect(Collectors.toList()));
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"spnegoHandler"})
    public AuthenticationHandler spnegoHandler(@Qualifier(value="spnegoAuthentications") BeanContainer<Authentication> spnegoAuthentications, @Qualifier(value="spnegoPrincipalFactory") PrincipalFactory spnegoPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        SpnegoProperties spnegoProperties = casProperties.getAuthn().getSpnego();
        return new JcifsSpnegoAuthenticationHandler(spnegoProperties.getName(), servicesManager, spnegoPrincipalFactory, spnegoAuthentications.toList(), spnegoProperties.isPrincipalWithDomainName(), spnegoProperties.isNtlmAllowed(), spnegoProperties.getOrder());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnProperty(prefix="cas.authn.ntlm", name={"enabled"}, havingValue="true")
    public AuthenticationHandler ntlmAuthenticationHandler(@Qualifier(value="ntlmPrincipalFactory") PrincipalFactory ntlmPrincipalFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties) {
        NtlmProperties ntlmProperties = casProperties.getAuthn().getNtlm();
        return new NtlmAuthenticationHandler(ntlmProperties.getName(), servicesManager, ntlmPrincipalFactory, ntlmProperties.isLoadBalance(), ntlmProperties.getDomainController(), ntlmProperties.getIncludePattern(), ntlmProperties.getOrder());
    }

    @ConditionalOnMissingBean(name={"ntlmPrincipalFactory"})
    @Bean
    public PrincipalFactory ntlmPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"spnegoPrincipalResolver"})
    public PrincipalResolver spnegoPrincipalResolver(@Qualifier(value="spnegoPrincipalFactory") PrincipalFactory spnegoPrincipalFactory, @Qualifier(value="attributeRepository") IPersonAttributeDao attributeRepository, CasConfigurationProperties casProperties) {
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        PersonDirectoryPrincipalResolverProperties spnegoPrincipal = casProperties.getAuthn().getSpnego().getPrincipal();
        IAttributeMerger attributeMerger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger());
        return CoreAuthenticationUtils.newPersonDirectoryPrincipalResolver((PrincipalFactory)spnegoPrincipalFactory, (IPersonAttributeDao)attributeRepository, (IAttributeMerger)attributeMerger, SpnegoPrincipalResolver.class, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{spnegoPrincipal, personDirectory});
    }

    @ConditionalOnMissingBean(name={"spnegoPrincipalFactory"})
    @Bean
    public PrincipalFactory spnegoPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"spnegoAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer spnegoAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="ntlmAuthenticationHandler") ObjectProvider<AuthenticationHandler> ntlmAuthenticationHandler, @Qualifier(value="spnegoPrincipalResolver") PrincipalResolver spnegoPrincipalResolver, @Qualifier(value="spnegoHandler") AuthenticationHandler spnegoHandler) {
        return plan -> {
            plan.registerAuthenticationHandlerWithPrincipalResolver(spnegoHandler, spnegoPrincipalResolver);
            ntlmAuthenticationHandler.ifAvailable(arg_0 -> ((AuthenticationEventExecutionPlan)plan).registerAuthenticationHandler(arg_0));
        };
    }
}

