/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.security.auth.login.FailedLoginException;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.metadata.BasicCredentialMetaData;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="6.3.0")
public class NtlmAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(NtlmAuthenticationHandler.class);
    private static final int NBT_ADDRESS_TYPE = 28;
    private static final int NTLM_TOKEN_TYPE_FIELD_INDEX = 8;
    private static final int NTLM_TOKEN_TYPE_ONE = 1;
    private static final int NTLM_TOKEN_TYPE_THREE = 3;
    private static final String DEFAULT_DOMAIN_CONTROLLER = Config.getProperty((String)"jcifs.smb.client.domain");
    private final String domainController;
    private final String includePattern;
    private final boolean loadBalance;

    public NtlmAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, boolean loadBalance, String domainController, String includePattern, Integer order) {
        super(name, servicesManager, principalFactory, order);
        this.loadBalance = loadBalance;
        this.domainController = StringUtils.isBlank((CharSequence)domainController) ? DEFAULT_DOMAIN_CONTROLLER : domainController;
        this.includePattern = includePattern;
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return SpnegoCredential.class.isAssignableFrom(clazz);
    }

    public boolean supports(Credential credential) {
        return credential instanceof SpnegoCredential;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException {
        SpnegoCredential ntlmCredential = (SpnegoCredential)credential;
        byte[] src = ntlmCredential.getInitToken();
        boolean success = false;
        try {
            UniAddress dc = this.getUniAddress();
            byte[] challenge = SmbSession.getChallenge((UniAddress)dc);
            switch (src[8]) {
                case 1: {
                    LOGGER.debug("Type 1 received");
                    Type1Message type1 = new Type1Message(src);
                    Type2Message type2 = new Type2Message(type1, challenge, null);
                    LOGGER.debug("Type 2 returned. Setting next token.");
                    ntlmCredential.setNextToken(type2.toByteArray());
                    break;
                }
                case 3: {
                    LOGGER.debug("Type 3 received");
                    Type3Message type3 = new Type3Message(src);
                    byte[] lmResponse = type3.getLMResponse() == null ? ArrayUtils.EMPTY_BYTE_ARRAY : type3.getLMResponse();
                    byte[] ntResponse = type3.getNTResponse() == null ? ArrayUtils.EMPTY_BYTE_ARRAY : type3.getNTResponse();
                    NtlmPasswordAuthentication ntlm = new NtlmPasswordAuthentication(type3.getDomain(), type3.getUser(), challenge, lmResponse, ntResponse);
                    LOGGER.debug("Trying to authenticate [{}] with domain controller", (Object)type3.getUser());
                    try {
                        SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
                        ntlmCredential.setPrincipal(this.principalFactory.createPrincipal(type3.getUser()));
                        success = true;
                        break;
                    }
                    catch (SmbAuthException sae) {
                        throw new FailedLoginException(sae.getMessage());
                    }
                }
                default: {
                    LOGGER.debug("Unknown type: [{}]", (Object)src[8]);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new FailedLoginException(e.getMessage());
        }
        if (!success) {
            throw new FailedLoginException();
        }
        return new DefaultAuthenticationHandlerExecutionResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData((Credential)ntlmCredential), ntlmCredential.getPrincipal());
    }

    private UniAddress getUniAddress() {
        if (this.loadBalance) {
            if (StringUtils.isNotBlank((CharSequence)this.includePattern)) {
                NbtAddress[] dcs = NbtAddress.getAllByName((String)this.domainController, (int)28, null, null);
                return Arrays.stream(dcs).filter(dc2 -> dc2.getHostAddress().matches(this.includePattern)).findFirst().map(UniAddress::new).orElse(null);
            }
            return new UniAddress((Object)NbtAddress.getByName((String)this.domainController, (int)28, null));
        }
        return UniAddress.getByName((String)this.domainController, (boolean)true);
    }
}

