/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.stream.Collectors;
import jcifs.spnego.Authentication;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ntlm.NtlmProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoSystemProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsConfig;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.handler.support.NtlmAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoPrincipalResolver;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Configuration(value="spnegoConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SpnegoConfiguration {
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="attributeRepository")
    private ObjectProvider<IPersonAttributeDao> attributeRepository;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"spnegoAuthentications"})
    public List<Authentication> spnegoAuthentications() {
        SpnegoSystemProperties spnegoSystem = this.casProperties.getAuthn().getSpnego().getSystem();
        JcifsConfig.SystemSettings.initialize((ResourceLoader)this.applicationContext, spnegoSystem.getLoginConf());
        Resource kerbConf = this.applicationContext.getResource(spnegoSystem.getKerberosConf());
        FunctionUtils.doAndIgnore(o -> JcifsConfig.SystemSettings.setKerberosConf(kerbConf.getFile().getCanonicalPath()), (Object[])new Object[0]);
        JcifsConfig.SystemSettings.setKerberosDebug(spnegoSystem.getKerberosDebug());
        JcifsConfig.SystemSettings.setKerberosKdc(spnegoSystem.getKerberosKdc());
        JcifsConfig.SystemSettings.setKerberosRealm(spnegoSystem.getKerberosRealm());
        JcifsConfig.SystemSettings.setUseSubjectCredsOnly(spnegoSystem.isUseSubjectCredsOnly());
        List props = this.casProperties.getAuthn().getSpnego().getProperties();
        return props.stream().map(p -> {
            JcifsConfig c = new JcifsConfig();
            JcifsConfig.JcifsSettings jcifsSettings = c.getJcifsSettings();
            jcifsSettings.setJcifsDomain(p.getJcifsDomain());
            jcifsSettings.setJcifsDomainController(p.getJcifsDomainController());
            jcifsSettings.setJcifsNetbiosCachePolicy(p.getCachePolicy());
            jcifsSettings.setJcifsNetbiosWins(p.getJcifsNetbiosWins());
            jcifsSettings.setJcifsPassword(p.getJcifsPassword());
            jcifsSettings.setJcifsServicePassword(p.getJcifsServicePassword());
            jcifsSettings.setJcifsServicePrincipal(p.getJcifsServicePrincipal());
            jcifsSettings.setJcifsSocketTimeout(Beans.newDuration((String)p.getTimeout()).toMillis());
            jcifsSettings.setJcifsUsername(p.getJcifsUsername());
            return new Authentication(jcifsSettings.getProperties());
        }).collect(Collectors.toList());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"spnegoHandler"})
    public AuthenticationHandler spnegoHandler() {
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        return new JcifsSpnegoAuthenticationHandler(spnegoProperties.getName(), (ServicesManager)this.servicesManager.getObject(), this.spnegoPrincipalFactory(), this.spnegoAuthentications(), spnegoProperties.isPrincipalWithDomainName(), spnegoProperties.isNtlmAllowed(), spnegoProperties.getOrder());
    }

    @Bean
    @RefreshScope
    @ConditionalOnProperty(prefix="cas.authn.ntlm", name={"enabled"}, havingValue="true")
    public AuthenticationHandler ntlmAuthenticationHandler() {
        NtlmProperties ntlmProperties = this.casProperties.getAuthn().getNtlm();
        return new NtlmAuthenticationHandler(ntlmProperties.getName(), (ServicesManager)this.servicesManager.getObject(), this.ntlmPrincipalFactory(), ntlmProperties.isLoadBalance(), ntlmProperties.getDomainController(), ntlmProperties.getIncludePattern(), ntlmProperties.getOrder());
    }

    @ConditionalOnMissingBean(name={"ntlmPrincipalFactory"})
    @Bean
    public PrincipalFactory ntlmPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"spnegoPrincipalResolver"})
    public PrincipalResolver spnegoPrincipalResolver() {
        PersonDirectoryPrincipalResolverProperties personDirectory = this.casProperties.getPersonDirectory();
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        PersonDirectoryPrincipalResolverProperties spnegoPrincipal = spnegoProperties.getPrincipal();
        String principalAttribute = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)spnegoPrincipal.getPrincipalAttribute(), (CharSequence)personDirectory.getPrincipalAttribute());
        return new SpnegoPrincipalResolver((IPersonAttributeDao)this.attributeRepository.getObject(), this.spnegoPrincipalFactory(), spnegoPrincipal.isReturnNull() || personDirectory.isReturnNull(), PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)spnegoProperties.getPrincipalTransformation()), principalAttribute, spnegoPrincipal.isUseExistingPrincipalId() || personDirectory.isUseExistingPrincipalId(), spnegoPrincipal.isAttributeResolutionEnabled(), StringUtils.commaDelimitedListToSet((String)spnegoPrincipal.getActiveAttributeRepositoryIds()));
    }

    @ConditionalOnMissingBean(name={"spnegoPrincipalFactory"})
    @Bean
    public PrincipalFactory spnegoPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"spnegoAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer spnegoAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            plan.registerAuthenticationHandlerWithPrincipalResolver(this.spnegoHandler(), this.spnegoPrincipalResolver());
            if (this.casProperties.getAuthn().getNtlm().isEnabled()) {
                plan.registerAuthenticationHandler(this.ntlmAuthenticationHandler());
            }
        };
    }
}

