/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import jcifs.spnego.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.MockJcifsAuthentication;
import org.apereo.cas.support.spnego.MockUnsuccessfulJcifsAuthentication;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="Spnego")
public class JcifsSpnegoAuthenticationHandlerTests {
    private static final String USERNAME = "Username";

    @Test
    public void verifySuccessfulAuthenticationWithDomainName() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), true, true, null);
        Assertions.assertNotNull((Object)authenticationHandler.authenticate((Credential)credentials));
        Assertions.assertEquals((Object)"test", (Object)credentials.getPrincipal().getId());
        Assertions.assertNotNull((Object)credentials.getNextToken());
        Assertions.assertTrue((boolean)authenticationHandler.supports(credentials.getClass()));
    }

    @Test
    public void verifySuccessfulAuthenticationWithoutDomainName() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), false, true, null);
        Assertions.assertNotNull((Object)authenticationHandler.authenticate((Credential)credentials));
        Assertions.assertEquals((Object)"test", (Object)credentials.getPrincipal().getId());
        Assertions.assertNotNull((Object)credentials.getNextToken());
    }

    @Test
    public void verifyUnsuccessfulAuthenticationWithExceptionOnProcess() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockUnsuccessfulJcifsAuthentication(true)}), true, true, null);
        JcifsSpnegoAuthenticationHandlerTests.authenticate(credentials, authenticationHandler);
    }

    private static void authenticate(SpnegoCredential credentials, JcifsSpnegoAuthenticationHandler authenticationHandler) throws PreventedException {
        try {
            authenticationHandler.authenticate((Credential)credentials);
            throw new AssertionError((Object)"An AbstractAuthenticationException should have been thrown");
        }
        catch (GeneralSecurityException e) {
            Assertions.assertNull((Object)credentials.getNextToken());
            Assertions.assertNull((Object)credentials.getPrincipal());
            return;
        }
    }

    @Test
    public void verifyUnsuccessfulAuthentication() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockUnsuccessfulJcifsAuthentication(false)}), true, true, null);
        JcifsSpnegoAuthenticationHandlerTests.authenticate(credentials, authenticationHandler);
    }

    @Test
    public void verifySupports() {
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), true, true, null);
        Assertions.assertFalse((boolean)authenticationHandler.supports((Credential)((SpnegoCredential)null)));
        Assertions.assertTrue((boolean)authenticationHandler.supports((Credential)new SpnegoCredential(new byte[]{0, 1, 2})));
        Assertions.assertFalse((boolean)authenticationHandler.supports((Credential)new UsernamePasswordCredential()));
    }

    @Test
    public void verifyGetSimpleCredentials() {
        String myNtlmUser = "DOMAIN\\Username";
        String myNtlmUserWithNoDomain = USERNAME;
        String myKerberosUser = "Username@DOMAIN.COM";
        PrincipalFactory factory = PrincipalFactoryUtils.newPrincipalFactory();
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), true, true, null);
        Assertions.assertEquals((Object)factory.createPrincipal("DOMAIN\\Username"), (Object)authenticationHandler.getPrincipal("DOMAIN\\Username", true));
        Assertions.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)authenticationHandler.getPrincipal(USERNAME, false));
        Assertions.assertEquals((Object)factory.createPrincipal("Username@DOMAIN.COM"), (Object)authenticationHandler.getPrincipal("Username@DOMAIN.COM", false));
        JcifsSpnegoAuthenticationHandler handlerNoDomain = new JcifsSpnegoAuthenticationHandler("", (ServicesManager)Mockito.mock(ServicesManager.class), PrincipalFactoryUtils.newPrincipalFactory(), CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), false, true, null);
        Assertions.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal("DOMAIN\\Username", true));
        Assertions.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal(USERNAME, true));
        Assertions.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal("Username@DOMAIN.COM", false));
    }
}

