/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.principal;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpnegoCredential
implements Credential {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoCredential.class);
    private static final long serialVersionUID = 84084596791289548L;
    private static final int NTLM_TOKEN_MAX_LENGTH = 8;
    private static final Byte CHAR_S_BYTE = 83;
    private static final Byte[] NTLMSSP_SIGNATURE = new Byte[]{(byte)78, (byte)84, (byte)76, (byte)77, CHAR_S_BYTE, CHAR_S_BYTE, (byte)80, (byte)0};
    private byte[] initToken;
    private byte[] nextToken;
    private Principal principal;
    private boolean isNtlm;

    public SpnegoCredential(@NonNull byte[] initToken) {
        if (initToken == null) {
            throw new NullPointerException("initToken is marked non-null but is null");
        }
        this.initToken = SpnegoCredential.consumeByteSourceOrNull(ByteSource.wrap((byte[])initToken));
        this.isNtlm = SpnegoCredential.isTokenNtlm(this.initToken);
    }

    private static boolean isTokenNtlm(byte[] token) {
        if (token == null || token.length < 8) {
            return false;
        }
        return IntStream.range(0, 8).noneMatch(i -> NTLMSSP_SIGNATURE[i] != token[i]);
    }

    private static byte[] consumeByteSourceOrNull(ByteSource source) {
        try {
            if (source == null || source.isEmpty()) {
                return null;
            }
            return source.read();
        }
        catch (IOException e) {
            LoggingUtils.warn((Logger)LOGGER, (String)"Could not consume the byte array source", (Throwable)e);
            return null;
        }
    }

    public String getId() {
        return this.principal != null ? this.principal.getId() : "unknown";
    }

    @Generated
    public String toString() {
        return "SpnegoCredential(principal=" + this.principal + ", isNtlm=" + this.isNtlm + ")";
    }

    @Generated
    public void setInitToken(byte[] initToken) {
        this.initToken = initToken;
    }

    @Generated
    public void setNextToken(byte[] nextToken) {
        this.nextToken = nextToken;
    }

    @Generated
    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    @Generated
    public void setNtlm(boolean isNtlm) {
        this.isNtlm = isNtlm;
    }

    @Generated
    public byte[] getInitToken() {
        return this.initToken;
    }

    @Generated
    public byte[] getNextToken() {
        return this.nextToken;
    }

    @Generated
    public Principal getPrincipal() {
        return this.principal;
    }

    @Generated
    public boolean isNtlm() {
        return this.isNtlm;
    }

    @Generated
    public SpnegoCredential() {
    }

    @Generated
    public SpnegoCredential(byte[] initToken, byte[] nextToken, Principal principal, boolean isNtlm) {
        this.initToken = initToken;
        this.nextToken = nextToken;
        this.principal = principal;
        this.isNtlm = isNtlm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpnegoCredential)) {
            return false;
        }
        SpnegoCredential other = (SpnegoCredential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.initToken, other.initToken)) {
            return false;
        }
        if (!Arrays.equals(this.nextToken, other.nextToken)) {
            return false;
        }
        Principal this$principal = this.principal;
        Principal other$principal = other.principal;
        return !(this$principal == null ? other$principal != null : !this$principal.equals(other$principal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpnegoCredential;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.initToken);
        result = result * 59 + Arrays.hashCode(this.nextToken);
        Principal $principal = this.principal;
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        return result;
    }
}

