/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import java.net.URL;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class JcifsConfig {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JcifsConfig.class);
    public static final SystemSettings SYSTEM_SETTINGS = new SystemSettings();
    private final JcifsSettings jcifsSettings = new JcifsSettings();

    @Generated
    public JcifsSettings getJcifsSettings() {
        return this.jcifsSettings;
    }

    public static class JcifsSettings {
        private final Properties properties = new Properties();

        public JcifsSettings() {
            this.properties.setProperty("jcifs.smb.client.soTimeout", "300000");
            this.properties.setProperty("jcifs.netbios.cachePolicy", "600");
        }

        public void setJcifsServicePassword(String jcifsServicePassword) {
            if (StringUtils.isNotBlank((CharSequence)jcifsServicePassword)) {
                LOGGER.debug("jcifsServicePassword is set");
                this.properties.setProperty("jcifs.spnego.servicePassword", jcifsServicePassword);
            }
        }

        public void setJcifsServicePrincipal(String jcifsServicePrincipal) {
            if (StringUtils.isNotBlank((CharSequence)jcifsServicePrincipal)) {
                LOGGER.debug("jcifsServicePrincipal is set to [{}]", (Object)jcifsServicePrincipal);
                this.properties.setProperty("jcifs.spnego.servicePrincipal", jcifsServicePrincipal);
            }
        }

        public void setJcifsDomain(String jcifsDomain) {
            if (StringUtils.isNotBlank((CharSequence)jcifsDomain)) {
                LOGGER.debug("jcifsDomain is set to [{}]", (Object)jcifsDomain);
                this.properties.setProperty("jcifs.smb.client.domain", jcifsDomain);
            }
        }

        public void setJcifsDomainController(String jcifsDomainController) {
            if (StringUtils.isNotBlank((CharSequence)jcifsDomainController)) {
                LOGGER.debug("jcifsDomainController is set to [{}]", (Object)jcifsDomainController);
                this.properties.setProperty("jcifs.http.domainController", jcifsDomainController);
            }
        }

        public void setJcifsPassword(String jcifsPassword) {
            if (StringUtils.isNotBlank((CharSequence)jcifsPassword)) {
                this.properties.setProperty("jcifs.smb.client.password", jcifsPassword);
            }
        }

        public void setJcifsUsername(String jcifsUsername) {
            if (StringUtils.isNotBlank((CharSequence)jcifsUsername)) {
                LOGGER.debug("jcifsUsername is set to [{}]", (Object)jcifsUsername);
                this.properties.setProperty("jcifs.smb.client.username", jcifsUsername);
            }
        }

        public void setJcifsNetbiosWins(String jcifsNetbiosWins) {
            if (StringUtils.isNotBlank((CharSequence)jcifsNetbiosWins)) {
                LOGGER.debug("jcifsNetbiosWins is set to [{}]", (Object)jcifsNetbiosWins);
                this.properties.setProperty("jcifs.netbios.wins", jcifsNetbiosWins);
            }
        }

        public void setJcifsNetbiosCachePolicy(long policy) {
            if (policy > 0L) {
                LOGGER.debug("jcifsNetbiosCachePolicy is set to [{}]", (Object)policy);
                this.properties.setProperty("jcifs.netbios.cachePolicy", String.valueOf(policy));
            }
        }

        public void setJcifsSocketTimeout(long timeout) {
            if (timeout > 0L) {
                LOGGER.debug("jcifsSocketTimeout is set to [{}]", (Object)timeout);
                this.properties.setProperty("jcifs.smb.client.soTimeout", String.valueOf(timeout));
            }
        }

        @Generated
        public Properties getProperties() {
            return this.properties;
        }
    }

    public static class SystemSettings {
        public static void initialize(ResourceLoader resourceLoader, String loginConf) {
            String propValue = System.getProperty("java.security.auth.login.config");
            if (StringUtils.isNotBlank((CharSequence)propValue)) {
                LOGGER.info("Found login config [{}] in system property [{}]", (Object)propValue, (Object)"java.security.auth.login.config");
                if (StringUtils.isNotBlank((CharSequence)loginConf)) {
                    LOGGER.warn("Configured login config for CAS under [{}] will be ignored", (Object)loginConf);
                }
            } else {
                String effectiveLoginConf = StringUtils.isBlank((CharSequence)loginConf) ? "/login.conf" : loginConf;
                LOGGER.debug("Attempting to load login config from [{}]", (Object)loginConf);
                Resource res = resourceLoader.getResource(effectiveLoginConf);
                if (res.exists()) {
                    String urlPath = res.getURL().toExternalForm();
                    LOGGER.debug("Located login config [{}] and configured it under [{}]", (Object)urlPath, (Object)"java.security.auth.login.config");
                    System.setProperty("java.security.auth.login.config", urlPath);
                } else {
                    URL url = JcifsConfig.class.getResource("/jcifs/http/login.conf");
                    if (url != null) {
                        String fullUrl = url.toExternalForm();
                        LOGGER.debug("Falling back unto default login config [{}] under [{}]", (Object)fullUrl, (Object)"java.security.auth.login.config");
                        System.setProperty("java.security.auth.login.config", fullUrl);
                    }
                }
                LOGGER.debug("configured login configuration path : [{}]", (Object)propValue);
            }
        }

        public static void setKerberosConf(String kerberosConf) {
            if (StringUtils.isNotBlank((CharSequence)kerberosConf)) {
                LOGGER.debug("kerberosConf is set to :[{}]", (Object)kerberosConf);
                System.setProperty("java.security.krb5.conf", kerberosConf);
            }
        }

        public static void setKerberosKdc(String kerberosKdc) {
            if (StringUtils.isNotBlank((CharSequence)kerberosKdc)) {
                LOGGER.debug("kerberosKdc is set to : [{}]", (Object)kerberosKdc);
                System.setProperty("java.security.krb5.kdc", kerberosKdc);
            }
        }

        public static void setKerberosRealm(String kerberosRealm) {
            if (StringUtils.isNotBlank((CharSequence)kerberosRealm)) {
                LOGGER.debug("kerberosRealm is set to :[{}]", (Object)kerberosRealm);
                System.setProperty("java.security.krb5.realm", kerberosRealm);
            }
        }

        public static void setUseSubjectCredsOnly(boolean useSubjectCredsOnly) {
            LOGGER.debug("useSubjectCredsOnly is set to [{}]", (Object)useSubjectCredsOnly);
            System.setProperty("javax.security.auth.useSubjectCredsOnly", Boolean.toString(useSubjectCredsOnly));
        }

        public static void setKerberosDebug(String kerberosDebug) {
            if (StringUtils.isNotBlank((CharSequence)kerberosDebug)) {
                LOGGER.debug("kerberosDebug is set to : [{}]", (Object)kerberosDebug);
                System.setProperty("sun.security.krb5.debug", kerberosDebug);
            }
        }
    }
}

