/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.principal;

import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Simple")
public class SpnegoCredentialsTests {
    @Test
    public void verifyToStringWithNoPrincipal() {
        SpnegoCredential credentials = new SpnegoCredential(ArrayUtils.EMPTY_BYTE_ARRAY);
        Assertions.assertTrue((boolean)credentials.getId().contains("unknown"));
    }

    @Test
    public void verifyToStringWithPrincipal() {
        SpnegoCredential credentials = new SpnegoCredential(ArrayUtils.EMPTY_BYTE_ARRAY);
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("test");
        credentials.setPrincipal(principal);
        Assertions.assertEquals((Object)"test", (Object)credentials.getId());
    }

    @Test
    public void verifyPrincipalAffectsHash() {
        SpnegoCredential credential = new SpnegoCredential(ArrayUtils.EMPTY_BYTE_ARRAY);
        int hash1 = credential.hashCode();
        Principal principal = PrincipalFactoryUtils.newPrincipalFactory().createPrincipal("test");
        credential.setPrincipal(principal);
        int hash2 = credential.hashCode();
        Assertions.assertNotEquals((int)hash1, (int)hash2);
    }
}

