/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import org.apereo.cas.support.spnego.authentication.handler.support.JcifsConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ResourceLoader;

@SpringBootTest(classes={RefreshAutoConfiguration.class})
public class JcifsConfigTests {
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @Test
    public void verifyKerbSysConfig() {
        String path = new ClassPathResource("kerb5.conf").getFile().getCanonicalPath();
        final String loginConf = new ClassPathResource("jaas.conf").getFile().getCanonicalPath();
        final JcifsConfig.SystemSettings settings = new JcifsConfig.SystemSettings();
        JcifsConfig.SystemSettings.setKerberosDebug((String)"true");
        JcifsConfig.SystemSettings.setKerberosConf((String)("file:" + path));
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                JcifsConfig.SystemSettings.initialize((ResourceLoader)JcifsConfigTests.this.applicationContext, (String)("file:" + loginConf));
            }
        });
    }

    @Test
    public void verifyJcifsConfig() {
        Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() {
                JcifsConfig.JcifsSettings settings = new JcifsConfig.JcifsSettings();
                settings.setJcifsDomain("DOMAIN");
                settings.setJcifsDomainController("CONTROLLER");
                settings.setJcifsNetbiosCachePolicy(1000L);
                settings.setJcifsPassword("PASS");
                settings.setJcifsServicePassword("P@$$");
                settings.setJcifsServicePrincipal("EXAMPLE/Principal");
                settings.setJcifsSocketTimeout(100L);
                settings.setJcifsUsername("Principal");
            }
        });
    }
}

