/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.principal;

import java.util.Optional;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.SimpleTestUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoPrincipalResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SpnegoCredentialsToPrincipalResolverTests {
    private SpnegoPrincipalResolver resolver;
    private SpnegoCredential spnegoCredentials;

    @BeforeEach
    public void initialize() {
        this.resolver = new SpnegoPrincipalResolver();
        this.spnegoCredentials = new SpnegoCredential(new byte[]{0, 1, 2});
    }

    @Test
    public void verifyValidCredentials() {
        this.spnegoCredentials.setPrincipal(new DefaultPrincipalFactory().createPrincipal("test"));
        Assertions.assertEquals((Object)"test", (Object)this.resolver.resolve((Credential)this.spnegoCredentials, Optional.of(CoreAuthenticationTestUtils.getPrincipal()), Optional.of(new SimpleTestUsernamePasswordAuthenticationHandler())).getId());
    }

    @Test
    public void verifySupports() {
        Assertions.assertFalse((boolean)this.resolver.supports(null));
        Assertions.assertTrue((boolean)this.resolver.supports((Credential)this.spnegoCredentials));
        Assertions.assertFalse((boolean)this.resolver.supports((Credential)new UsernamePasswordCredential()));
    }
}

