/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import jcifs.spnego.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.MockJcifsAuthentication;
import org.apereo.cas.support.spnego.MockUnsuccessfulJcifsAuthentication;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.apereo.cas.util.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JcifsSpnegoAuthenticationHandlerTests {
    private static final String USERNAME = "Username";

    @Test
    public void verifySuccessfulAuthenticationWithDomainName() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), true, true, null);
        Assert.assertNotNull((Object)authenticationHandler.authenticate((Credential)credentials));
        Assert.assertEquals((Object)"test", (Object)credentials.getPrincipal().getId());
        Assert.assertNotNull((Object)credentials.getNextToken());
    }

    @Test
    public void verifySuccessfulAuthenticationWithoutDomainName() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), false, true, null);
        Assert.assertNotNull((Object)authenticationHandler.authenticate((Credential)credentials));
        Assert.assertEquals((Object)"test", (Object)credentials.getPrincipal().getId());
        Assert.assertNotNull((Object)credentials.getNextToken());
    }

    @Test
    public void verifyUnsuccessfulAuthenticationWithExceptionOnProcess() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockUnsuccessfulJcifsAuthentication(true)}), true, true, null);
        JcifsSpnegoAuthenticationHandlerTests.authenticate(credentials, authenticationHandler);
    }

    private static void authenticate(SpnegoCredential credentials, JcifsSpnegoAuthenticationHandler authenticationHandler) throws PreventedException {
        try {
            authenticationHandler.authenticate((Credential)credentials);
            throw new AssertionError((Object)"An AbstractAuthenticationException should have been thrown");
        }
        catch (GeneralSecurityException e) {
            Assert.assertNull((Object)credentials.getNextToken());
            Assert.assertNull((Object)credentials.getPrincipal());
            return;
        }
    }

    @Test
    public void verifyUnsuccessfulAuthentication() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockUnsuccessfulJcifsAuthentication(false)}), true, true, null);
        JcifsSpnegoAuthenticationHandlerTests.authenticate(credentials, authenticationHandler);
    }

    @Test
    public void verifySupports() {
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), true, true, null);
        Assert.assertFalse((boolean)authenticationHandler.supports((Credential)((SpnegoCredential)null)));
        Assert.assertTrue((boolean)authenticationHandler.supports((Credential)new SpnegoCredential(new byte[]{0, 1, 2})));
        Assert.assertFalse((boolean)authenticationHandler.supports((Credential)new UsernamePasswordCredential()));
    }

    @Test
    public void verifyGetSimpleCredentials() {
        String myNtlmUser = "DOMAIN\\Username";
        String myNtlmUserWithNoDomain = USERNAME;
        String myKerberosUser = "Username@DOMAIN.COM";
        DefaultPrincipalFactory factory = new DefaultPrincipalFactory();
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), true, true, null);
        Assert.assertEquals((Object)factory.createPrincipal("DOMAIN\\Username"), (Object)authenticationHandler.getPrincipal("DOMAIN\\Username", true));
        Assert.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)authenticationHandler.getPrincipal(USERNAME, false));
        Assert.assertEquals((Object)factory.createPrincipal("Username@DOMAIN.COM"), (Object)authenticationHandler.getPrincipal("Username@DOMAIN.COM", false));
        JcifsSpnegoAuthenticationHandler handlerNoDomain = new JcifsSpnegoAuthenticationHandler("", (ServicesManager)Mockito.mock(ServicesManager.class), (PrincipalFactory)new DefaultPrincipalFactory(), CollectionUtils.wrapList((Object[])new Authentication[]{new MockJcifsAuthentication()}), false, true, null);
        Assert.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal("DOMAIN\\Username", true));
        Assert.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal(USERNAME, true));
        Assert.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal("Username@DOMAIN.COM", false));
    }
}

