/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import com.google.common.base.Splitter;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import javax.security.auth.login.FailedLoginException;
import jcifs.spnego.Authentication;
import jcifs.spnego.AuthenticationException;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.BasicCredentialMetaData;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class JcifsSpnegoAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JcifsSpnegoAuthenticationHandler.class);
    @Generated
    private final Object $lock = new Object[0];
    private Authentication authentication;
    private boolean principalWithDomainName;
    private boolean ntlmAllowed;

    public JcifsSpnegoAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Authentication authentication, boolean principalWithDomainName, boolean ntlmAllowed) {
        super(name, servicesManager, principalFactory, null);
        this.authentication = authentication;
        this.principalWithDomainName = principalWithDomainName;
        this.ntlmAllowed = ntlmAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException {
        Object object = this.$lock;
        synchronized (object) {
            byte[] nextToken;
            Principal principal;
            SpnegoCredential spnegoCredential = (SpnegoCredential)credential;
            if (!this.ntlmAllowed && spnegoCredential.isNtlm()) {
                throw new FailedLoginException("NTLM not allowed");
            }
            try {
                this.authentication.reset();
                LOGGER.debug("Processing SPNEGO authentication");
                this.authentication.process(spnegoCredential.getInitToken());
                principal = this.authentication.getPrincipal();
                LOGGER.debug("Authenticated SPNEGO principal [{}]", (Object)(principal != null ? principal.getName() : null));
                LOGGER.debug("Retrieving the next token for authentication");
                nextToken = this.authentication.getNextToken();
            }
            catch (AuthenticationException e) {
                LOGGER.debug("Processing SPNEGO authentication failed with exception", (Throwable)e);
                throw new FailedLoginException(e.getMessage());
            }
            if (nextToken != null) {
                LOGGER.debug("Setting nextToken in credential");
                spnegoCredential.setNextToken(nextToken);
            } else {
                LOGGER.debug("nextToken is null");
            }
            boolean success = false;
            if (principal != null) {
                if (spnegoCredential.isNtlm()) {
                    LOGGER.debug("NTLM Credential is valid for user [{}]", (Object)principal.getName());
                } else {
                    LOGGER.debug("Kerberos Credential is valid for user [{}]", (Object)principal.getName());
                }
                spnegoCredential.setPrincipal(this.getPrincipal(principal.getName(), spnegoCredential.isNtlm()));
                success = true;
            }
            if (!success) {
                throw new FailedLoginException("Principal is null, the processing of the SPNEGO Token failed");
            }
            return new DefaultAuthenticationHandlerExecutionResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData(credential), spnegoCredential.getPrincipal());
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof SpnegoCredential;
    }

    protected org.apereo.cas.authentication.principal.Principal getPrincipal(String name, boolean isNtlm) {
        if (this.principalWithDomainName) {
            return this.principalFactory.createPrincipal(name);
        }
        if (isNtlm) {
            List splitList;
            if (Pattern.matches("\\S+\\\\\\S+", name) && (splitList = Splitter.on((Pattern)Pattern.compile("\\\\")).splitToList((CharSequence)name)).size() == 2) {
                return this.principalFactory.createPrincipal((String)splitList.get(1));
            }
            return this.principalFactory.createPrincipal(name);
        }
        List splitList = Splitter.on((String)"@").splitToList((CharSequence)name);
        return this.principalFactory.createPrincipal((String)splitList.get(0));
    }

    @Generated
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    @Generated
    public void setPrincipalWithDomainName(boolean principalWithDomainName) {
        this.principalWithDomainName = principalWithDomainName;
    }

    @Generated
    public void setNtlmAllowed(boolean ntlmAllowed) {
        this.ntlmAllowed = ntlmAllowed;
    }
}

