/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jcifs.spnego.Authentication;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ntlm.NtlmProperties;
import org.apereo.cas.configuration.model.support.spnego.SpnegoProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsConfig;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.handler.support.NtlmAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoPrincipalResolver;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="spnegoConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SpnegoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoConfiguration.class);
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="attributeRepository")
    private IPersonAttributeDao attributeRepository;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"spnegoAuthentication"})
    public Authentication spnegoAuthentication() {
        return new Authentication();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"jcifsConfig"})
    public JcifsConfig jcifsConfig() {
        JcifsConfig c = new JcifsConfig();
        SpnegoProperties spnego = this.casProperties.getAuthn().getSpnego();
        c.setJcifsDomain(spnego.getJcifsDomain());
        c.setJcifsDomainController(spnego.getJcifsDomainController());
        c.setJcifsNetbiosCachePolicy(spnego.getCachePolicy());
        c.setJcifsNetbiosWins(spnego.getJcifsNetbiosWins());
        c.setJcifsPassword(spnego.getJcifsPassword());
        c.setJcifsServicePassword(spnego.getJcifsServicePassword());
        c.setJcifsServicePrincipal(spnego.getJcifsServicePrincipal());
        c.setJcifsSocketTimeout(Beans.newDuration((String)spnego.getTimeout()).toMillis());
        c.setJcifsUsername(spnego.getJcifsUsername());
        c.setKerberosConf(spnego.getKerberosConf());
        c.setKerberosDebug(spnego.getKerberosDebug());
        c.setKerberosKdc(spnego.getKerberosKdc());
        c.setKerberosRealm(spnego.getKerberosRealm());
        c.setLoginConf(spnego.getLoginConf());
        c.setUseSubjectCredsOnly(spnego.isUseSubjectCredsOnly());
        return c;
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"spnegoHandler"})
    public AuthenticationHandler spnegoHandler() {
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        JcifsSpnegoAuthenticationHandler h = new JcifsSpnegoAuthenticationHandler(spnegoProperties.getName(), this.servicesManager, this.spnegoPrincipalFactory(), this.spnegoAuthentication(), spnegoProperties.isPrincipalWithDomainName(), spnegoProperties.isNtlmAllowed());
        h.setAuthentication(this.spnegoAuthentication());
        h.setPrincipalWithDomainName(spnegoProperties.isPrincipalWithDomainName());
        h.setNtlmAllowed(spnegoProperties.isNtlmAllowed());
        return h;
    }

    @Bean
    @RefreshScope
    public AuthenticationHandler ntlmAuthenticationHandler() {
        NtlmProperties ntlmProperties = this.casProperties.getAuthn().getNtlm();
        return new NtlmAuthenticationHandler(ntlmProperties.getName(), this.servicesManager, this.ntlmPrincipalFactory(), ntlmProperties.isLoadBalance(), ntlmProperties.getDomainController(), ntlmProperties.getIncludePattern());
    }

    @ConditionalOnMissingBean(name={"ntlmPrincipalFactory"})
    @Bean
    public PrincipalFactory ntlmPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"spnegoPrincipalResolver"})
    public PrincipalResolver spnegoPrincipalResolver() {
        SpnegoProperties spnegoProperties = this.casProperties.getAuthn().getSpnego();
        return new SpnegoPrincipalResolver(this.attributeRepository, this.spnegoPrincipalFactory(), spnegoProperties.getPrincipal().isReturnNull(), PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)spnegoProperties.getPrincipalTransformation()), spnegoProperties.getPrincipal().getPrincipalAttribute());
    }

    @ConditionalOnMissingBean(name={"spnegoPrincipalFactory"})
    @Bean
    public PrincipalFactory spnegoPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"spnegoAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer spnegoAuthenticationEventExecutionPlanConfigurer() {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(this.spnegoHandler(), this.spnegoPrincipalResolver());
    }
}

