/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import java.net.URL;
import javax.annotation.PostConstruct;
import jcifs.Config;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class JcifsConfig {
    private static final String DEFAULT_LOGIN_CONFIG = "/login.conf";
    private static final String SYS_PROP_USE_SUBJECT_CRED_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final String SYS_PROP_LOGIN_CONF = "java.security.auth.login.config";
    private static final String SYS_PROP_KERBEROS_DEBUG = "sun.security.krb5.debug";
    private static final String SYS_PROP_KERBEROS_CONF = "java.security.krb5.conf";
    private static final String SYS_PROP_KERBEROS_REALM = "java.security.krb5.realm";
    private static final String SYS_PROP_KERBEROS_KDC = "java.security.krb5.kdc";
    private static final String JCIFS_PROP_DOMAIN_CONTROLLER = "jcifs.http.domainController";
    private static final String JCIFS_PROP_NETBIOS_WINS = "jcifs.netbios.wins";
    private static final String JCIFS_PROP_CLIENT_DOMAIN = "jcifs.smb.client.domain";
    private static final String JCIFS_PROP_CLIENT_USERNAME = "jcifs.smb.client.username";
    private static final String JCIFS_PROP_CLIENT_PASSWORD = "jcifs.smb.client.password";
    private static final String JCIFS_PROP_CLIENT_SOTIMEOUT = "jcifs.smb.client.soTimeout";
    private static final String JCIFS_PROP_NETBIOS_CACHE_POLICY = "jcifs.netbios.cachePolicy";
    private static final String JCIFS_PROP_SERVICE_PRINCIPAL = "jcifs.spnego.servicePrincipal";
    private static final String JCIFS_PROP_SERVICE_PASSWORD = "jcifs.spnego.servicePassword";
    private static final Logger LOGGER = LoggerFactory.getLogger(JcifsConfig.class);
    private String loginConf;
    @Autowired
    private ResourceLoader resourceLoader;

    public JcifsConfig() {
        Config.setProperty((String)JCIFS_PROP_CLIENT_SOTIMEOUT, (String)"300000");
        Config.setProperty((String)JCIFS_PROP_NETBIOS_CACHE_POLICY, (String)"600");
    }

    @PostConstruct
    public void init() {
        this.configureJaasLoginConfig();
    }

    protected void configureJaasLoginConfig() {
        try {
            String propValue = System.getProperty(SYS_PROP_LOGIN_CONF);
            if (StringUtils.isNotBlank((CharSequence)propValue)) {
                LOGGER.info("Found login config [{}] in system property [{}]", (Object)propValue, (Object)SYS_PROP_LOGIN_CONF);
                if (StringUtils.isNotBlank((CharSequence)this.loginConf)) {
                    LOGGER.warn("Configured login config for CAS under [{}] will be ignored", (Object)this.loginConf);
                }
            } else {
                String loginConf = StringUtils.isBlank((CharSequence)this.loginConf) ? DEFAULT_LOGIN_CONFIG : this.loginConf;
                LOGGER.debug("Attempting to load login config from [{}]", (Object)loginConf);
                Resource res = this.resourceLoader.getResource(loginConf);
                if (res != null && res.exists()) {
                    String urlPath = res.getURL().toExternalForm();
                    LOGGER.debug("Located login config [{}] and configured it under [{}]", (Object)urlPath, (Object)SYS_PROP_LOGIN_CONF);
                    System.setProperty(SYS_PROP_LOGIN_CONF, urlPath);
                } else {
                    URL url = this.getClass().getResource("/jcifs/http/login.conf");
                    if (url != null) {
                        LOGGER.debug("Falling back unto default login config [{}] under [{}]", (Object)url.toExternalForm(), (Object)SYS_PROP_LOGIN_CONF);
                        System.setProperty(SYS_PROP_LOGIN_CONF, url.toExternalForm());
                    }
                }
                LOGGER.debug("configured login configuration path : [{}]", (Object)propValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setJcifsServicePassword(String jcifsServicePassword) {
        if (StringUtils.isNotBlank((CharSequence)jcifsServicePassword)) {
            LOGGER.debug("jcifsServicePassword is set to *****");
            Config.setProperty((String)JCIFS_PROP_SERVICE_PASSWORD, (String)jcifsServicePassword);
        }
    }

    public void setJcifsServicePrincipal(String jcifsServicePrincipal) {
        if (StringUtils.isNotBlank((CharSequence)jcifsServicePrincipal)) {
            LOGGER.debug("jcifsServicePrincipal is set to [{}]", (Object)jcifsServicePrincipal);
            Config.setProperty((String)JCIFS_PROP_SERVICE_PRINCIPAL, (String)jcifsServicePrincipal);
        }
    }

    public void setKerberosConf(String kerberosConf) {
        if (StringUtils.isNotBlank((CharSequence)kerberosConf)) {
            LOGGER.debug("kerberosConf is set to :[{}]", (Object)kerberosConf);
            System.setProperty(SYS_PROP_KERBEROS_CONF, kerberosConf);
        }
    }

    public void setKerberosKdc(String kerberosKdc) {
        if (StringUtils.isNotBlank((CharSequence)kerberosKdc)) {
            LOGGER.debug("kerberosKdc is set to : [{}]", (Object)kerberosKdc);
            System.setProperty(SYS_PROP_KERBEROS_KDC, kerberosKdc);
        }
    }

    public void setKerberosRealm(String kerberosRealm) {
        if (StringUtils.isNotBlank((CharSequence)kerberosRealm)) {
            LOGGER.debug("kerberosRealm is set to :[{}]", (Object)kerberosRealm);
            System.setProperty(SYS_PROP_KERBEROS_REALM, kerberosRealm);
        }
    }

    public void setLoginConf(String loginConf) {
        this.loginConf = loginConf;
    }

    public void setUseSubjectCredsOnly(boolean useSubjectCredsOnly) {
        LOGGER.debug("useSubjectCredsOnly is set to [{}]", (Object)useSubjectCredsOnly);
        System.setProperty(SYS_PROP_USE_SUBJECT_CRED_ONLY, Boolean.toString(useSubjectCredsOnly));
    }

    public void setKerberosDebug(String kerberosDebug) {
        if (StringUtils.isNotBlank((CharSequence)kerberosDebug)) {
            LOGGER.debug("kerberosDebug is set to : [{}]", (Object)kerberosDebug);
            System.setProperty(SYS_PROP_KERBEROS_DEBUG, kerberosDebug);
        }
    }

    public void setJcifsDomain(String jcifsDomain) {
        if (StringUtils.isNotBlank((CharSequence)jcifsDomain)) {
            LOGGER.debug("jcifsDomain is set to [{}]", (Object)jcifsDomain);
            Config.setProperty((String)JCIFS_PROP_CLIENT_DOMAIN, (String)jcifsDomain);
        }
    }

    public void setJcifsDomainController(String jcifsDomainController) {
        if (StringUtils.isNotBlank((CharSequence)jcifsDomainController)) {
            LOGGER.debug("jcifsDomainController is set to [{}]", (Object)jcifsDomainController);
            Config.setProperty((String)JCIFS_PROP_DOMAIN_CONTROLLER, (String)jcifsDomainController);
        }
    }

    public void setJcifsPassword(String jcifsPassword) {
        if (StringUtils.isNotBlank((CharSequence)jcifsPassword)) {
            Config.setProperty((String)JCIFS_PROP_CLIENT_PASSWORD, (String)jcifsPassword);
            LOGGER.debug("jcifsPassword is set to *****");
        }
    }

    public void setJcifsUsername(String jcifsUsername) {
        if (StringUtils.isNotBlank((CharSequence)jcifsUsername)) {
            LOGGER.debug("jcifsUsername is set to [{}]", (Object)jcifsUsername);
            Config.setProperty((String)JCIFS_PROP_CLIENT_USERNAME, (String)jcifsUsername);
        }
    }

    public void setJcifsNetbiosWins(String jcifsNetbiosWins) {
        if (StringUtils.isNotBlank((CharSequence)jcifsNetbiosWins)) {
            LOGGER.debug("jcifsNetbiosWins is set to [{}]", (Object)jcifsNetbiosWins);
            Config.setProperty((String)JCIFS_PROP_NETBIOS_WINS, (String)jcifsNetbiosWins);
        }
    }

    public void setJcifsNetbiosCachePolicy(long policy) {
        if (policy > 0L) {
            LOGGER.debug("jcifsNetbiosCachePolicy is set to [{}]", (Object)policy);
            Config.setProperty((String)JCIFS_PROP_NETBIOS_CACHE_POLICY, (String)String.valueOf(policy));
        }
    }

    public void setJcifsSocketTimeout(long timeout) {
        if (timeout > 0L) {
            LOGGER.debug("jcifsSocketTimeout is set to [{}]", (Object)timeout);
            Config.setProperty((String)JCIFS_PROP_CLIENT_SOTIMEOUT, (String)String.valueOf(timeout));
        }
    }
}

