/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import jcifs.spnego.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.support.spnego.MockJcifsAuthentication;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.junit.Assert;
import org.junit.Test;

public class JcifsSpnegoAuthenticationHandlerTests {
    private static final String USERNAME = "Username";

    @Test
    public void verifySuccessfulAuthenticationWithDomainName() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, (Authentication)new MockJcifsAuthentication(true), true, true);
        Assert.assertNotNull((Object)authenticationHandler.authenticate((Credential)credentials));
        Assert.assertEquals((Object)"test", (Object)credentials.getPrincipal().getId());
        Assert.assertNotNull((Object)credentials.getNextToken());
    }

    @Test
    public void verifySuccessfulAuthenticationWithoutDomainName() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, (Authentication)new MockJcifsAuthentication(true), false, true);
        Assert.assertNotNull((Object)authenticationHandler.authenticate((Credential)credentials));
        Assert.assertEquals((Object)"test", (Object)credentials.getPrincipal().getId());
        Assert.assertNotNull((Object)credentials.getNextToken());
    }

    @Test
    public void verifyUnsuccessfulAuthentication() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, (Authentication)new MockJcifsAuthentication(false), true, true);
        try {
            authenticationHandler.authenticate((Credential)credentials);
            Assert.fail((String)"An AbstractAuthenticationException should have been thrown");
        }
        catch (GeneralSecurityException e) {
            Assert.assertNull((Object)credentials.getNextToken());
            Assert.assertNull((Object)credentials.getPrincipal());
        }
    }

    @Test
    public void verifySupports() {
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, (Authentication)new MockJcifsAuthentication(true), true, true);
        Assert.assertFalse((boolean)authenticationHandler.supports(null));
        Assert.assertTrue((boolean)authenticationHandler.supports((Credential)new SpnegoCredential(new byte[]{0, 1, 2})));
        Assert.assertFalse((boolean)authenticationHandler.supports((Credential)new UsernamePasswordCredential()));
    }

    @Test
    public void verifyGetSimpleCredentials() {
        String myNtlmUser = "DOMAIN\\Username";
        String myNtlmUserWithNoDomain = USERNAME;
        String myKerberosUser = "Username@DOMAIN.COM";
        DefaultPrincipalFactory factory = new DefaultPrincipalFactory();
        JcifsSpnegoAuthenticationHandler authenticationHandler = new JcifsSpnegoAuthenticationHandler("", null, null, (Authentication)new MockJcifsAuthentication(true), true, true);
        Assert.assertEquals((Object)factory.createPrincipal("DOMAIN\\Username"), (Object)authenticationHandler.getPrincipal("DOMAIN\\Username", true));
        Assert.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)authenticationHandler.getPrincipal(USERNAME, false));
        Assert.assertEquals((Object)factory.createPrincipal("Username@DOMAIN.COM"), (Object)authenticationHandler.getPrincipal("Username@DOMAIN.COM", false));
        JcifsSpnegoAuthenticationHandler handlerNoDomain = new JcifsSpnegoAuthenticationHandler("", null, null, (Authentication)new MockJcifsAuthentication(true), false, true);
        Assert.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal("DOMAIN\\Username", true));
        Assert.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal(USERNAME, true));
        Assert.assertEquals((Object)factory.createPrincipal(USERNAME), (Object)handlerNoDomain.getPrincipal("Username@DOMAIN.COM", false));
    }
}

