/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseDNSRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReverseDNSRunnable.class);
    private String ipAddress;
    private String hostName;

    public ReverseDNSRunnable(String ipAddress) {
        this.ipAddress = ipAddress;
        this.hostName = ipAddress;
    }

    @Override
    public void run() {
        try {
            LOGGER.debug("Attempting to resolve [{}]", (Object)this.ipAddress);
            InetAddress address = InetAddress.getByName(this.ipAddress);
            this.set(address.getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            LOGGER.debug("Unable to identify the canonical hostname for ip address.", (Throwable)e);
        }
    }

    public synchronized void set(String hostName) {
        LOGGER.trace("ReverseDNS -- Found hostName: [{}].", (Object)hostName);
        this.hostName = hostName;
    }

    public synchronized String get() {
        return this.hostName;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ipAddress", (Object)this.ipAddress).append("hostName", (Object)this.hostName).toString();
    }
}

