/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.principal;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SpnegoCredential
implements Credential,
Serializable {
    private static final long serialVersionUID = 84084596791289548L;
    private static final int NTLM_TOKEN_MAX_LENGTH = 8;
    private static final Byte CHAR_S_BYTE = 83;
    private static final Byte[] NTLMSSP_SIGNATURE = new Byte[]{(byte)78, (byte)84, (byte)76, (byte)77, CHAR_S_BYTE, CHAR_S_BYTE, (byte)80, (byte)0};
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private byte[] initToken;
    private byte[] nextToken;
    private Principal principal;
    private boolean isNtlm;

    public SpnegoCredential(byte[] initToken) {
        Assert.notNull((Object)initToken, (String)"The initToken cannot be null.");
        this.initToken = this.consumeByteSourceOrNull(ByteSource.wrap((byte[])initToken));
        this.isNtlm = SpnegoCredential.isTokenNtlm(this.initToken);
    }

    public byte[] getInitToken() {
        return this.initToken;
    }

    public byte[] getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(byte[] nextToken) {
        this.nextToken = this.consumeByteSourceOrNull(ByteSource.wrap((byte[])nextToken));
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public boolean isNtlm() {
        return this.isNtlm;
    }

    public String getId() {
        return this.principal != null ? this.principal.getId() : "unknown";
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isTokenNtlm(byte[] token) {
        if (token == null || token.length < 8) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (NTLMSSP_SIGNATURE[i] == token[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SpnegoCredential c = (SpnegoCredential)obj;
        return Arrays.equals(this.getInitToken(), c.getInitToken()) && this.principal.equals(c.getPrincipal()) && Arrays.equals(this.getNextToken(), c.getNextToken());
    }

    public int hashCode() {
        int hash = super.hashCode();
        if (this.principal != null) {
            hash = this.principal.hashCode();
        }
        return new HashCodeBuilder().append(this.getInitToken()).append(this.getNextToken()).append(hash).toHashCode();
    }

    private byte[] consumeByteSourceOrNull(ByteSource source) {
        try {
            if (source == null || source.isEmpty()) {
                return null;
            }
            return source.read();
        }
        catch (IOException e) {
            this.logger.warn("Could not consume the byte array source", (Throwable)e);
            return null;
        }
    }
}

