/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.principal;

import java.util.HashSet;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.junit.Assert;
import org.junit.Test;

public class SpnegoCredentialsTests {
    @Test
    public void verifyToStringWithNoPrincipal() {
        SpnegoCredential credentials = new SpnegoCredential(new byte[0]);
        Assert.assertTrue((boolean)credentials.toString().contains("unknown"));
    }

    @Test
    public void verifyToStringWithPrincipal() {
        SpnegoCredential credentials = new SpnegoCredential(new byte[0]);
        Principal principal = new DefaultPrincipalFactory().createPrincipal("test");
        credentials.setPrincipal(principal);
        Assert.assertEquals((Object)"test", (Object)credentials.toString());
    }

    @Test
    public void verifyCredentialsHashSafelyWithoutPrincipal() {
        SpnegoCredential credential = new SpnegoCredential(new byte[0]);
        HashSet<SpnegoCredential> set = new HashSet<SpnegoCredential>();
        try {
            set.add(credential);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void verifyPrincipalAffectsHash() {
        SpnegoCredential credential = new SpnegoCredential(new byte[0]);
        int hash1 = credential.hashCode();
        Principal principal = new DefaultPrincipalFactory().createPrincipal("test");
        credential.setPrincipal(principal);
        int hash2 = credential.hashCode();
        Assert.assertNotEquals((long)hash1, (long)hash2);
    }
}

