/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import jcifs.spnego.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.support.spnego.MockJcifsAuthentication;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JcifsSpnegoAuthenticationHandlerTests {
    private JcifsSpnegoAuthenticationHandler authenticationHandler;

    @Before
    public void setUp() throws Exception {
        this.authenticationHandler = new JcifsSpnegoAuthenticationHandler();
    }

    @Test
    public void verifySuccessfulAuthenticationWithDomainName() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        this.authenticationHandler.setPrincipalWithDomainName(true);
        this.authenticationHandler.setAuthentication((Authentication)new MockJcifsAuthentication(true));
        Assert.assertNotNull((Object)this.authenticationHandler.authenticate((Credential)credentials));
        Assert.assertEquals((Object)"test", (Object)credentials.getPrincipal().getId());
        Assert.assertNotNull((Object)credentials.getNextToken());
    }

    @Test
    public void verifySuccessfulAuthenticationWithoutDomainName() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        this.authenticationHandler.setPrincipalWithDomainName(false);
        this.authenticationHandler.setAuthentication((Authentication)new MockJcifsAuthentication(true));
        Assert.assertNotNull((Object)this.authenticationHandler.authenticate((Credential)credentials));
        Assert.assertEquals((Object)"test", (Object)credentials.getPrincipal().getId());
        Assert.assertNotNull((Object)credentials.getNextToken());
    }

    @Test
    public void verifyUnsuccessfulAuthentication() throws Exception {
        SpnegoCredential credentials = new SpnegoCredential(new byte[]{0, 1, 2});
        this.authenticationHandler.setAuthentication((Authentication)new MockJcifsAuthentication(false));
        try {
            this.authenticationHandler.authenticate((Credential)credentials);
            Assert.fail((String)"An AbstractAuthenticationException should have been thrown");
        }
        catch (GeneralSecurityException e) {
            Assert.assertNull((Object)credentials.getNextToken());
            Assert.assertNull((Object)credentials.getPrincipal());
        }
    }

    @Test
    public void verifySupports() {
        Assert.assertFalse((boolean)this.authenticationHandler.supports(null));
        Assert.assertTrue((boolean)this.authenticationHandler.supports((Credential)new SpnegoCredential(new byte[]{0, 1, 2})));
        Assert.assertFalse((boolean)this.authenticationHandler.supports((Credential)new UsernamePasswordCredential()));
    }

    @Test
    public void verifyGetSimpleCredentials() {
        String myNtlmUser = "DOMAIN\\Username";
        String myNtlmUserWithNoDomain = "Username";
        String myKerberosUser = "Username@DOMAIN.COM";
        DefaultPrincipalFactory factory = new DefaultPrincipalFactory();
        this.authenticationHandler.setPrincipalWithDomainName(true);
        Assert.assertEquals((Object)factory.createPrincipal("DOMAIN\\Username"), (Object)this.authenticationHandler.getPrincipal("DOMAIN\\Username", true));
        Assert.assertEquals((Object)factory.createPrincipal("Username"), (Object)this.authenticationHandler.getPrincipal("Username", false));
        Assert.assertEquals((Object)factory.createPrincipal("Username@DOMAIN.COM"), (Object)this.authenticationHandler.getPrincipal("Username@DOMAIN.COM", false));
        this.authenticationHandler.setPrincipalWithDomainName(false);
        Assert.assertEquals((Object)factory.createPrincipal("Username"), (Object)this.authenticationHandler.getPrincipal("DOMAIN\\Username", true));
        Assert.assertEquals((Object)factory.createPrincipal("Username"), (Object)this.authenticationHandler.getPrincipal("Username", true));
        Assert.assertEquals((Object)factory.createPrincipal("Username"), (Object)this.authenticationHandler.getPrincipal("Username@DOMAIN.COM", false));
    }
}

