/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.security.auth.login.FailedLoginException;
import jcifs.spnego.Authentication;
import jcifs.spnego.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.BasicCredentialMetaData;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultHandlerResult;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoCredential;

public class JcifsSpnegoAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private Authentication authentication;
    private boolean principalWithDomainName;
    private boolean isNTLMallowed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        byte[] nextToken;
        Principal principal;
        SpnegoCredential spnegoCredential = (SpnegoCredential)credential;
        if (!this.isNTLMallowed && spnegoCredential.isNtlm()) {
            throw new FailedLoginException("NTLM not allowed");
        }
        try {
            JcifsSpnegoAuthenticationHandler jcifsSpnegoAuthenticationHandler = this;
            synchronized (jcifsSpnegoAuthenticationHandler) {
                this.authentication.reset();
                this.logger.debug("Processing SPNEGO authentication");
                this.authentication.process(spnegoCredential.getInitToken());
                principal = this.authentication.getPrincipal();
                this.logger.debug("Authenticated SPNEGO principal {}", (Object)principal.getName());
                this.logger.debug("Retrieving the next token for authentication");
                nextToken = this.authentication.getNextToken();
            }
        }
        catch (AuthenticationException e) {
            throw new FailedLoginException(e.getMessage());
        }
        if (nextToken != null) {
            this.logger.debug("Setting nextToken in credential");
            spnegoCredential.setNextToken(nextToken);
        } else {
            this.logger.debug("nextToken is null");
        }
        boolean success = false;
        if (principal != null) {
            if (spnegoCredential.isNtlm()) {
                this.logger.debug("NTLM Credential is valid for user [{}]", (Object)principal.getName());
            } else {
                this.logger.debug("Kerberos Credential is valid for user [{}]", (Object)principal.getName());
            }
            spnegoCredential.setPrincipal(this.getPrincipal(principal.getName(), spnegoCredential.isNtlm()));
            success = true;
        }
        if (!success) {
            throw new FailedLoginException("Principal is null, the processing of the SPNEGO Token failed");
        }
        return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData(credential), spnegoCredential.getPrincipal());
    }

    public boolean supports(Credential credential) {
        return credential instanceof SpnegoCredential;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setPrincipalWithDomainName(boolean principalWithDomainName) {
        this.principalWithDomainName = principalWithDomainName;
    }

    public void setNTLMallowed(boolean isNTLMallowed) {
        this.isNTLMallowed = isNTLMallowed;
    }

    protected org.apereo.cas.authentication.principal.Principal getPrincipal(String name, boolean isNtlm) {
        if (this.principalWithDomainName) {
            return this.principalFactory.createPrincipal(name);
        }
        if (isNtlm) {
            return Pattern.matches("\\S+\\\\\\S+", name) ? this.principalFactory.createPrincipal(name.split("\\\\")[1]) : this.principalFactory.createPrincipal(name);
        }
        return this.principalFactory.createPrincipal(name.split("@")[0]);
    }
}

