/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Map;
import javax.annotation.PostConstruct;
import jcifs.spnego.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsConfig;
import org.apereo.cas.support.spnego.authentication.handler.support.JcifsSpnegoAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.handler.support.NtlmAuthenticationHandler;
import org.apereo.cas.support.spnego.authentication.principal.SpnegoPrincipalResolver;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="spnegoConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class SpnegoConfiguration {
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="attributeRepository")
    private IPersonAttributeDao attributeRepository;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RefreshScope
    @Bean
    public Authentication spnegoAuthentication() {
        return new Authentication();
    }

    @Bean
    @RefreshScope
    public JcifsConfig jcifsConfig() {
        JcifsConfig c = new JcifsConfig();
        c.setJcifsDomain(this.casProperties.getAuthn().getSpnego().getJcifsDomain());
        c.setJcifsDomainController(this.casProperties.getAuthn().getSpnego().getJcifsDomainController());
        c.setJcifsNetbiosCachePolicy(this.casProperties.getAuthn().getSpnego().getCachePolicy());
        c.setJcifsNetbiosWins(this.casProperties.getAuthn().getSpnego().getJcifsNetbiosWins());
        c.setJcifsPassword(this.casProperties.getAuthn().getSpnego().getJcifsPassword());
        c.setJcifsServicePassword(this.casProperties.getAuthn().getSpnego().getJcifsServicePassword());
        c.setJcifsServicePrincipal(this.casProperties.getAuthn().getSpnego().getJcifsServicePrincipal());
        c.setJcifsSocketTimeout(this.casProperties.getAuthn().getSpnego().getTimeout());
        c.setJcifsUsername(this.casProperties.getAuthn().getSpnego().getJcifsUsername());
        c.setKerberosConf(this.casProperties.getAuthn().getSpnego().getKerberosConf());
        c.setKerberosDebug(this.casProperties.getAuthn().getSpnego().getKerberosDebug());
        c.setKerberosKdc(this.casProperties.getAuthn().getSpnego().getKerberosKdc());
        c.setKerberosRealm(this.casProperties.getAuthn().getSpnego().getKerberosRealm());
        c.setLoginConf(this.casProperties.getAuthn().getSpnego().getLoginConf());
        c.setUseSubjectCredsOnly(this.casProperties.getAuthn().getSpnego().isUseSubjectCredsOnly());
        return c;
    }

    @Bean
    @RefreshScope
    public AuthenticationHandler spnegoHandler() {
        JcifsSpnegoAuthenticationHandler h = new JcifsSpnegoAuthenticationHandler();
        h.setPrincipalFactory(this.spnegoPrincipalFactory());
        h.setServicesManager(this.servicesManager);
        h.setAuthentication(this.spnegoAuthentication());
        h.setPrincipalWithDomainName(this.casProperties.getAuthn().getSpnego().isPrincipalWithDomainName());
        h.setNTLMallowed(this.casProperties.getAuthn().getSpnego().isNtlmAllowed());
        return h;
    }

    @Bean
    @RefreshScope
    public AuthenticationHandler ntlmAuthenticationHandler() {
        NtlmAuthenticationHandler ntlm = new NtlmAuthenticationHandler();
        ntlm.setDomainController(this.casProperties.getAuthn().getNtlm().getDomainController());
        ntlm.setIncludePattern(this.casProperties.getAuthn().getNtlm().getIncludePattern());
        ntlm.setLoadBalance(this.casProperties.getAuthn().getNtlm().isLoadBalance());
        ntlm.setPrincipalFactory(this.ntlmPrincipalFactory());
        ntlm.setServicesManager(this.servicesManager);
        return ntlm;
    }

    @Bean
    public PrincipalFactory ntlmPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    @RefreshScope
    public PrincipalResolver spnegoPrincipalResolver() {
        SpnegoPrincipalResolver r = new SpnegoPrincipalResolver();
        r.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)this.casProperties.getAuthn().getSpnego().getPrincipalTransformation()));
        r.setAttributeRepository(this.attributeRepository);
        r.setPrincipalAttributeName(this.casProperties.getAuthn().getSpnego().getPrincipal().getPrincipalAttribute());
        r.setReturnNullIfNoAttributes(this.casProperties.getAuthn().getSpnego().getPrincipal().isReturnNull());
        r.setPrincipalFactory(this.spnegoPrincipalFactory());
        return r;
    }

    @Bean
    public PrincipalFactory spnegoPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @PostConstruct
    protected void initializeRootApplicationContext() {
        this.authenticationHandlersResolvers.put(this.spnegoHandler(), this.spnegoPrincipalResolver());
    }
}

