/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.config.CasCoreAuthenticationAutoConfiguration;
import org.apereo.cas.config.CasCoreAutoConfiguration;
import org.apereo.cas.config.CasCoreCookieAutoConfiguration;
import org.apereo.cas.config.CasCoreLogoutAutoConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationAutoConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationWebflowAutoConfiguration;
import org.apereo.cas.config.CasCoreNotificationsAutoConfiguration;
import org.apereo.cas.config.CasCoreServicesAutoConfiguration;
import org.apereo.cas.config.CasCoreTicketsAutoConfiguration;
import org.apereo.cas.config.CasCoreUtilAutoConfiguration;
import org.apereo.cas.config.CasCoreWebAutoConfiguration;
import org.apereo.cas.config.CasCoreWebflowAutoConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.CasRadiusAutoConfiguration;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@SpringBootTest(classes={CasRadiusAutoConfiguration.class, RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, CasCoreAuthenticationAutoConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasCoreMultifactorAuthenticationAutoConfiguration.class, CasCoreMultifactorAuthenticationWebflowAutoConfiguration.class, CasCoreWebAutoConfiguration.class, CasCoreWebflowAutoConfiguration.class, CasCoreServicesAutoConfiguration.class, CasCoreNotificationsAutoConfiguration.class, CasCoreTicketsAutoConfiguration.class, CasCoreLogoutAutoConfiguration.class, CasCoreCookieAutoConfiguration.class, CasCoreUtilAutoConfiguration.class, CasCoreAutoConfiguration.class}, properties={"cas.authn.radius.server.protocol=PAP", "cas.authn.radius.client.shared-secret=testing123", "cas.authn.radius.client.inet-address=localhost", "cas.authn.mfa.radius.id=mfa-dummy"})
@Tag(value="Radius")
class RadiusAccessChallengedMultifactorAuthenticationTriggerTests {
    @Autowired
    @Qualifier(value="radiusAccessChallengedMultifactorAuthenticationTrigger")
    private MultifactorAuthenticationTrigger multifactorAuthenticationTrigger;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    RadiusAccessChallengedMultifactorAuthenticationTriggerTests() {
    }

    @Test
    void verifyTriggerInactive() throws Throwable {
        Assertions.assertTrue((boolean)this.multifactorAuthenticationTrigger.isActivated(CoreAuthenticationTestUtils.getAuthentication(), (RegisteredService)CoreAuthenticationTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), CoreAuthenticationTestUtils.getService()).isEmpty());
        Assertions.assertTrue((boolean)this.multifactorAuthenticationTrigger.isActivated(null, (RegisteredService)CoreAuthenticationTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), CoreAuthenticationTestUtils.getService()).isEmpty());
    }

    @Test
    void verifyTriggerActive() throws Throwable {
        Authentication authn = CoreAuthenticationTestUtils.getAuthentication((Principal)CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"Reply-Message", (Object)"reply-message", (String)"State", (Object)"whatever")));
        Assertions.assertThrows(AuthenticationException.class, () -> this.multifactorAuthenticationTrigger.isActivated(authn, (RegisteredService)CoreAuthenticationTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), CoreAuthenticationTestUtils.getService()));
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        Authentication authnMfa = CoreAuthenticationTestUtils.getAuthentication((Principal)CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"Reply-Message", (Object)"reply-message", (String)"State", (Object)"whatever")));
        Assertions.assertTrue((boolean)this.multifactorAuthenticationTrigger.isActivated(authnMfa, (RegisteredService)CoreAuthenticationTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), CoreAuthenticationTestUtils.getService()).isPresent());
    }
}

