/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.config.CasCoreAuthenticationAutoConfiguration;
import org.apereo.cas.config.CasCoreAutoConfiguration;
import org.apereo.cas.config.CasCoreCookieAutoConfiguration;
import org.apereo.cas.config.CasCoreLogoutAutoConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationAutoConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationWebflowAutoConfiguration;
import org.apereo.cas.config.CasCoreNotificationsAutoConfiguration;
import org.apereo.cas.config.CasCoreServicesAutoConfiguration;
import org.apereo.cas.config.CasCoreTicketsAutoConfiguration;
import org.apereo.cas.config.CasCoreUtilAutoConfiguration;
import org.apereo.cas.config.CasCoreWebAutoConfiguration;
import org.apereo.cas.config.CasCoreWebflowAutoConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.CasRadiusAutoConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockRequestContext;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@SpringBootTest(classes={CasCoreMultifactorAuthenticationAutoConfiguration.class, CasCoreMultifactorAuthenticationWebflowAutoConfiguration.class, CasCoreWebflowAutoConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasRadiusAutoConfiguration.class, CasCoreAutoConfiguration.class, CasCoreLogoutAutoConfiguration.class, CasCoreNotificationsAutoConfiguration.class, CasCoreTicketsAutoConfiguration.class, CasCoreUtilAutoConfiguration.class, CasCoreWebAutoConfiguration.class, CasCoreServicesAutoConfiguration.class, CasCoreAuthenticationAutoConfiguration.class, CasCoreCookieAutoConfiguration.class, WebMvcAutoConfiguration.class, RefreshAutoConfiguration.class}, properties={"cas.authn.radius.client.shared-secret=NoSecret", "cas.authn.radius.client.inet-address=localhost,localguest", "cas.authn.mfa.radius.id=mfa-dummy"})
@Tag(value="Radius")
class RadiusConfigurationTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="radiusAccessChallengedAuthenticationWebflowEventResolver")
    private ObjectProvider<CasWebflowEventResolver> radiusAccessChallengedAuthenticationWebflowEventResolver;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="radiusServers")
    private BeanContainer<RadiusServer> radiusServers;
    @Autowired
    @Qualifier(value="radiusServer")
    private RadiusServer radiusServer;

    RadiusConfigurationTests() {
    }

    @Test
    void emptyAddress() {
        RadiusClientProperties clientProperties = new RadiusClientProperties();
        clientProperties.setInetAddress("  ");
        Set ips = CasRadiusAutoConfiguration.getClientIps((RadiusClientProperties)clientProperties);
        Assertions.assertEquals((int)0, (int)ips.size());
    }

    @Test
    void someAddressesWithSpaces() {
        RadiusClientProperties clientProperties = new RadiusClientProperties();
        clientProperties.setInetAddress("localhost,  localguest  ");
        Set ips = CasRadiusAutoConfiguration.getClientIps((RadiusClientProperties)clientProperties);
        Assertions.assertEquals((int)2, (int)ips.size());
        Assertions.assertTrue((boolean)ips.contains("localhost"));
        Assertions.assertTrue((boolean)ips.contains("localguest"));
    }

    @Test
    void radiusServer() {
        Assertions.assertNotNull((Object)this.radiusServer);
    }

    @Test
    void radiusServers() {
        Assertions.assertEquals((Object)"localhost,localguest", (Object)this.casProperties.getAuthn().getRadius().getClient().getInetAddress());
        Assertions.assertNotNull(this.radiusServers);
        Assertions.assertEquals((int)2, (int)this.radiusServers.size());
    }

    @Test
    void verifyAccessChallengedWebflowEventResolver() throws Throwable {
        MockRequestContext context = MockRequestContext.create((ApplicationContext)this.applicationContext);
        Set result = ((CasWebflowEventResolver)this.radiusAccessChallengedAuthenticationWebflowEventResolver.getObject()).resolve((RequestContext)context);
        Assertions.assertNull((Object)result);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)"Reply-Message", (Object)"Reply-Back", (String)"State", (Object)"State".getBytes(StandardCharsets.UTF_8)));
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication((Principal)principal), (RequestContext)context);
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        DefaultTargetStateResolver targetResolver = new DefaultTargetStateResolver("mfa-dummy");
        Transition transition = new Transition((TransitionCriteria)new DefaultTransitionCriteria((Expression)new LiteralExpression("mfa-dummy")), (TargetStateResolver)targetResolver);
        context.getRootFlow().getGlobalTransitionSet().add(transition);
        result = ((CasWebflowEventResolver)this.radiusAccessChallengedAuthenticationWebflowEventResolver.getObject()).resolve((RequestContext)context);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"mfa-dummy", (Object)((Event)result.iterator().next()).getId());
    }
}

