/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.radius.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.config.CasCookieConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreLogoutConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreTicketsSerializationConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasCoreWebflowConfiguration;
import org.apereo.cas.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.config.CasWebflowContextConfiguration;
import org.apereo.cas.config.RadiusConfiguration;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@SpringBootTest(classes={RadiusConfiguration.class, RefreshAutoConfiguration.class, WebMvcAutoConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasPersonDirectoryTestConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreWebConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreWebflowConfiguration.class, CasWebflowContextConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreTicketsSerializationConfiguration.class, CasCoreLogoutConfiguration.class, CasCookieConfiguration.class, CasCoreHttpConfiguration.class, CasCoreUtilConfiguration.class, CasCoreConfiguration.class}, properties={"cas.authn.radius.server.protocol=PAP", "cas.authn.radius.client.shared-secret=testing123", "cas.authn.radius.client.inet-address=localhost", "cas.authn.mfa.radius.id=mfa-dummy"})
@Tag(value="Radius")
class RadiusAccessChallengedMultifactorAuthenticationTriggerTests {
    @Autowired
    @Qualifier(value="radiusAccessChallengedMultifactorAuthenticationTrigger")
    private MultifactorAuthenticationTrigger multifactorAuthenticationTrigger;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    RadiusAccessChallengedMultifactorAuthenticationTriggerTests() {
    }

    @Test
    void verifyTriggerInactive() throws Throwable {
        Assertions.assertTrue((boolean)this.multifactorAuthenticationTrigger.isActivated(CoreAuthenticationTestUtils.getAuthentication(), (RegisteredService)CoreAuthenticationTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), CoreAuthenticationTestUtils.getService()).isEmpty());
        Assertions.assertTrue((boolean)this.multifactorAuthenticationTrigger.isActivated(null, (RegisteredService)CoreAuthenticationTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), CoreAuthenticationTestUtils.getService()).isEmpty());
    }

    @Test
    void verifyTriggerActive() throws Throwable {
        Authentication authn = CoreAuthenticationTestUtils.getAuthentication((Principal)CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"Reply-Message", (Object)"reply-message", (String)"State", (Object)"whatever")));
        Assertions.assertThrows(AuthenticationException.class, () -> this.multifactorAuthenticationTrigger.isActivated(authn, (RegisteredService)CoreAuthenticationTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), CoreAuthenticationTestUtils.getService()));
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        Authentication authnMfa = CoreAuthenticationTestUtils.getAuthentication((Principal)CoreAuthenticationTestUtils.getPrincipal((Map)CollectionUtils.wrap((String)"Reply-Message", (Object)"reply-message", (String)"State", (Object)"whatever")));
        Assertions.assertTrue((boolean)this.multifactorAuthenticationTrigger.isActivated(authnMfa, (RegisteredService)CoreAuthenticationTestUtils.getRegisteredService(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse(), CoreAuthenticationTestUtils.getService()).isPresent());
    }
}

