/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.authentication.handler.support.RadiusAuthenticationHandler;
import org.apereo.cas.adaptors.radius.server.AbstractRadiusServer;
import org.apereo.cas.adaptors.radius.server.NonBlockingRadiusServer;
import org.apereo.cas.adaptors.radius.server.RadiusServerConfigurationContext;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAccessChallengedMultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusServerProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Radius})
@AutoConfiguration
public class RadiusConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.radius.client.inet-address");

    static Set<String> getClientIps(RadiusClientProperties client) {
        return StringUtils.commaDelimitedListToSet((String)StringUtils.trimAllWhitespace((String)client.getInetAddress()));
    }

    private static AbstractRadiusServer getSingleRadiusServer(RadiusClientProperties client, RadiusServerProperties server, String clientInetAddress, CasSSLContext casSSLContext) {
        RadiusClientFactory factory = RadiusClientFactory.builder().authenticationPort(client.getAccountingPort()).authenticationPort(client.getAuthenticationPort()).socketTimeout(client.getSocketTimeout()).inetAddress(clientInetAddress).sharedSecret(client.getSharedSecret()).sslContext(casSSLContext).transportType(client.getTransportType()).build();
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)server.getProtocol());
        RadiusServerConfigurationContext context = RadiusServerConfigurationContext.builder().protocol(protocol).radiusClientFactory(factory).retries(server.getRetries()).nasIpAddress(server.getNasIpAddress()).nasIpv6Address(server.getNasIpv6Address()).nasPort(server.getNasPort()).nasPortId(server.getNasPortId()).nasIdentifier(server.getNasIdentifier()).nasRealPort(server.getNasRealPort()).nasPortType((long)server.getNasPortType()).build();
        return new NonBlockingRadiusServer(context);
    }

    @ConditionalOnMissingBean(name={"radiusPrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory radiusPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public RadiusServer radiusServer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="casSslContext") CasSSLContext casSslContext) throws Exception {
        return (RadiusServer)BeanSupplier.of(RadiusServer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            RadiusProperties radius = casProperties.getAuthn().getRadius();
            RadiusClientProperties client = radius.getClient();
            RadiusServerProperties server = radius.getServer();
            Set<String> ips = RadiusConfiguration.getClientIps(client);
            return RadiusConfiguration.getSingleRadiusServer(client, server, ips.iterator().next(), casSslContext);
        }).otherwiseProxy().get();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public BeanContainer<RadiusServer> radiusServers(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSslContext") CasSSLContext casSslContext, CasConfigurationProperties casProperties) throws Exception {
        return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            RadiusProperties radius = casProperties.getAuthn().getRadius();
            RadiusClientProperties client = radius.getClient();
            RadiusServerProperties server = radius.getServer();
            Set<String> ips = RadiusConfiguration.getClientIps(radius.getClient());
            return BeanContainer.of(ips.stream().map(ip -> RadiusConfiguration.getSingleRadiusServer(client, server, ip, casSslContext)).collect(Collectors.toList()));
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"radiusAuthenticationHandler"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationHandler radiusAuthenticationHandler(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="radiusPrincipalFactory") PrincipalFactory radiusPrincipalFactory, @Qualifier(value="radiusServers") BeanContainer<RadiusServer> radiusServers, @Qualifier(value="radiusPasswordPolicyConfiguration") PasswordPolicyContext radiusPasswordPolicyConfiguration, @Qualifier(value="servicesManager") ServicesManager servicesManager) throws Exception {
        return (AuthenticationHandler)BeanSupplier.of(AuthenticationHandler.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            RadiusProperties radius = casProperties.getAuthn().getRadius();
            RadiusAuthenticationHandler h = new RadiusAuthenticationHandler(radius.getName(), servicesManager, radiusPrincipalFactory, radiusServers.toList(), radius.isFailoverOnException(), radius.isFailoverOnAuthenticationFailure());
            h.setState(radius.getState());
            h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)radius.getPasswordEncoder(), (ApplicationContext)applicationContext));
            h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)radius.getPrincipalTransformation()));
            h.setPasswordPolicyConfiguration(radiusPasswordPolicyConfiguration);
            return h;
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"radiusAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer radiusAuthenticationEventExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="radiusAuthenticationHandler") AuthenticationHandler radiusAuthenticationHandler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) throws Exception {
        return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
            Set<String> ips = RadiusConfiguration.getClientIps(casProperties.getAuthn().getRadius().getClient());
            if (!ips.isEmpty()) {
                plan.registerAuthenticationHandlerWithPrincipalResolver(radiusAuthenticationHandler, defaultPrincipalResolver);
            } else {
                LOGGER.warn("No RADIUS address is defined. RADIUS support will be disabled.");
            }
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"radiusPasswordPolicyConfiguration"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PasswordPolicyContext radiusPasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"radiusAccessChallengedMultifactorAuthenticationTrigger"})
    public MultifactorAuthenticationTrigger radiusAccessChallengedMultifactorAuthenticationTrigger(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="multifactorAuthenticationProviderResolver") MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver) throws Exception {
        return (MultifactorAuthenticationTrigger)BeanSupplier.of(MultifactorAuthenticationTrigger.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new RadiusAccessChallengedMultifactorAuthenticationTrigger(casProperties, multifactorAuthenticationProviderResolver, (ApplicationContext)applicationContext)).otherwiseProxy().get();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public CasWebflowEventResolver radiusAccessChallengedAuthenticationWebflowEventResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="radiusAccessChallengedMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger radiusAccessChallengedMultifactorAuthenticationTrigger, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) throws Exception {
        return (CasWebflowEventResolver)BeanSupplier.of(CasWebflowEventResolver.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            DefaultMultifactorAuthenticationProviderWebflowEventResolver resolver = new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, radiusAccessChallengedMultifactorAuthenticationTrigger);
            LOGGER.debug("Activating MFA event resolver based on RADIUS...");
            initialAuthenticationAttemptWebflowEventResolver.addDelegate((CasWebflowEventResolver)resolver);
            return resolver;
        }).otherwiseProxy().get();
    }
}

