/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasPersonDirectoryTestConfiguration;
import org.apereo.cas.config.RadiusConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasWebflowContextConfiguration;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={CasCoreMultifactorAuthenticationConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, CasWebflowContextConfiguration.class, CasCoreWebflowConfiguration.class, CasPersonDirectoryTestConfiguration.class, RadiusConfiguration.class, CasCoreConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreUtilConfiguration.class, CasCoreWebConfiguration.class, CasCoreHttpConfiguration.class, CasCoreAuthenticationConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCookieConfiguration.class, WebMvcAutoConfiguration.class, RefreshAutoConfiguration.class}, properties={"cas.authn.radius.client.shared-secret=NoSecret", "cas.authn.radius.client.inet-address=localhost,localguest", "cas.authn.mfa.radius.id=mfa-dummy"})
@Tag(value="Radius")
public class RadiusConfigurationTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="radiusAccessChallengedAuthenticationWebflowEventResolver")
    private ObjectProvider<CasWebflowEventResolver> radiusAccessChallengedAuthenticationWebflowEventResolver;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="radiusServers")
    private BeanContainer<RadiusServer> radiusServers;
    @Autowired
    @Qualifier(value="radiusServer")
    private RadiusServer radiusServer;

    @Test
    public void emptyAddress() {
        RadiusClientProperties clientProperties = new RadiusClientProperties();
        clientProperties.setInetAddress("  ");
        Set ips = RadiusConfiguration.getClientIps((RadiusClientProperties)clientProperties);
        Assertions.assertEquals((int)0, (int)ips.size());
    }

    @Test
    public void someAddressesWithSpaces() {
        RadiusClientProperties clientProperties = new RadiusClientProperties();
        clientProperties.setInetAddress("localhost,  localguest  ");
        Set ips = RadiusConfiguration.getClientIps((RadiusClientProperties)clientProperties);
        Assertions.assertEquals((int)2, (int)ips.size());
        Assertions.assertTrue((boolean)ips.contains("localhost"));
        Assertions.assertTrue((boolean)ips.contains("localguest"));
    }

    @Test
    public void radiusServer() {
        Assertions.assertNotNull((Object)this.radiusServer);
    }

    @Test
    public void radiusServers() {
        Assertions.assertEquals((Object)"localhost,localguest", (Object)this.casProperties.getAuthn().getRadius().getClient().getInetAddress());
        Assertions.assertNotNull(this.radiusServers);
        Assertions.assertEquals((int)2, (int)this.radiusServers.size());
    }

    @Test
    public void verifyAccessChallengedWebflowEventResolver() {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        Set result = ((CasWebflowEventResolver)this.radiusAccessChallengedAuthenticationWebflowEventResolver.getObject()).resolve((RequestContext)context);
        Assertions.assertNull((Object)result);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)"Reply-Message", (Object)"Reply-Back", (String)"State", (Object)"State".getBytes(StandardCharsets.UTF_8)));
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication((Principal)principal), (RequestContext)context);
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        DefaultTargetStateResolver targetResolver = new DefaultTargetStateResolver("mfa-dummy");
        Transition transition = new Transition((TransitionCriteria)new DefaultTransitionCriteria((Expression)new LiteralExpression("mfa-dummy")), (TargetStateResolver)targetResolver);
        context.getRootFlow().getGlobalTransitionSet().add(transition);
        result = ((CasWebflowEventResolver)this.radiusAccessChallengedAuthenticationWebflowEventResolver.getObject()).resolve((RequestContext)context);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"mfa-dummy", (Object)((Event)result.iterator().next()).getId());
    }
}

