/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.authentication.handler.support.RadiusAuthenticationHandler;
import org.apereo.cas.adaptors.radius.server.AbstractRadiusServer;
import org.apereo.cas.adaptors.radius.server.NonBlockingRadiusServer;
import org.apereo.cas.adaptors.radius.server.RadiusServerConfigurationContext;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAccessChallengedMultifactorAuthenticationTrigger;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusServerProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="radiusConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RadiusConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusConfiguration.class);
    @Autowired
    @Qualifier(value="registeredServiceAccessStrategyEnforcer")
    private ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderResolver")
    private ObjectProvider<MultifactorAuthenticationProviderResolver> multifactorAuthenticationProviderResolver;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private ObjectProvider<TicketRegistry> ticketRegistry;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderSelector")
    private ObjectProvider<MultifactorAuthenticationProviderSelector> multifactorAuthenticationProviderSelector;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private ObjectProvider<CasCookieBuilder> warnCookieGenerator;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;

    public static Set<String> getClientIps(RadiusClientProperties client) {
        return StringUtils.commaDelimitedListToSet((String)StringUtils.trimAllWhitespace((String)client.getInetAddress()));
    }

    @ConditionalOnMissingBean(name={"radiusPrincipalFactory"})
    @Bean
    public PrincipalFactory radiusPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public AbstractRadiusServer radiusServer() {
        RadiusProperties radius = this.casProperties.getAuthn().getRadius();
        RadiusClientProperties client = radius.getClient();
        RadiusServerProperties server = radius.getServer();
        Set<String> ips = RadiusConfiguration.getClientIps(client);
        return RadiusConfiguration.getSingleRadiusServer(client, server, ips.iterator().next());
    }

    @RefreshScope
    @Bean
    public List<RadiusServer> radiusServers() {
        RadiusProperties radius = this.casProperties.getAuthn().getRadius();
        RadiusClientProperties client = radius.getClient();
        RadiusServerProperties server = radius.getServer();
        Set<String> ips = RadiusConfiguration.getClientIps(radius.getClient());
        return ips.stream().map(ip -> RadiusConfiguration.getSingleRadiusServer(client, server, ip)).collect(Collectors.toList());
    }

    @ConditionalOnMissingBean(name={"radiusAuthenticationHandler"})
    @Bean
    public AuthenticationHandler radiusAuthenticationHandler() {
        RadiusProperties radius = this.casProperties.getAuthn().getRadius();
        RadiusAuthenticationHandler h = new RadiusAuthenticationHandler(radius.getName(), (ServicesManager)this.servicesManager.getIfAvailable(), this.radiusPrincipalFactory(), this.radiusServers(), radius.isFailoverOnException(), radius.isFailoverOnAuthenticationFailure());
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)radius.getPasswordEncoder()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)radius.getPrincipalTransformation()));
        h.setPasswordPolicyConfiguration(this.radiusPasswordPolicyConfiguration());
        return h;
    }

    @ConditionalOnMissingBean(name={"radiusAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer radiusAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            Set<String> ips = RadiusConfiguration.getClientIps(this.casProperties.getAuthn().getRadius().getClient());
            if (!ips.isEmpty()) {
                plan.registerAuthenticationHandlerWithPrincipalResolver(this.radiusAuthenticationHandler(), (PrincipalResolver)this.defaultPrincipalResolver.getObject());
            } else {
                LOGGER.warn("No RADIUS address is defined. RADIUS support will be disabled.");
            }
        };
    }

    @ConditionalOnMissingBean(name={"radiusPasswordPolicyConfiguration"})
    @Bean
    public PasswordPolicyContext radiusPasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @RefreshScope
    @Bean
    @ConditionalOnMissingBean(name={"radiusAccessChallengedMultifactorAuthenticationTrigger"})
    public MultifactorAuthenticationTrigger radiusAccessChallengedMultifactorAuthenticationTrigger() {
        return new RadiusAccessChallengedMultifactorAuthenticationTrigger(this.casProperties, (MultifactorAuthenticationProviderResolver)this.multifactorAuthenticationProviderResolver.getIfAvailable());
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver radiusAccessChallengedAuthenticationWebflowEventResolver() {
        CasWebflowEventResolutionConfigurationContext context = CasWebflowEventResolutionConfigurationContext.builder().authenticationSystemSupport((AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable()).centralAuthenticationService((CentralAuthenticationService)this.centralAuthenticationService.getIfAvailable()).servicesManager((ServicesManager)this.servicesManager.getIfAvailable()).ticketRegistrySupport((TicketRegistrySupport)this.ticketRegistrySupport.getIfAvailable()).warnCookieGenerator((CasCookieBuilder)this.warnCookieGenerator.getIfAvailable()).authenticationRequestServiceSelectionStrategies((AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getIfAvailable()).registeredServiceAccessStrategyEnforcer((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getIfAvailable()).casProperties(this.casProperties).ticketRegistry((TicketRegistry)this.ticketRegistry.getIfAvailable()).eventPublisher((ApplicationEventPublisher)this.applicationContext).applicationContext(this.applicationContext).build();
        DefaultMultifactorAuthenticationProviderWebflowEventResolver r = new DefaultMultifactorAuthenticationProviderWebflowEventResolver(context, this.radiusAccessChallengedMultifactorAuthenticationTrigger());
        LOGGER.debug("Activating MFA event resolver based on RADIUS...");
        ((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getIfAvailable()).addDelegate((CasWebflowEventResolver)r);
        return r;
    }

    private static AbstractRadiusServer getSingleRadiusServer(RadiusClientProperties client, RadiusServerProperties server, String clientInetAddress) {
        RadiusClientFactory factory = new RadiusClientFactory(client.getAccountingPort(), client.getAuthenticationPort(), client.getSocketTimeout(), clientInetAddress, client.getSharedSecret());
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)server.getProtocol());
        RadiusServerConfigurationContext context = RadiusServerConfigurationContext.builder().protocol(protocol).radiusClientFactory(factory).retries(server.getRetries()).nasIpAddress(server.getNasIpAddress()).nasIpv6Address(server.getNasIpv6Address()).nasPort(server.getNasPort()).nasPortId(server.getNasPortId()).nasIdentifier(server.getNasIdentifier()).nasRealPort(server.getNasRealPort()).nasPortType((long)server.getNasPortType()).build();
        return new NonBlockingRadiusServer(context);
    }
}

