/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.RadiusConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.LiteralExpression;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.engine.support.DefaultTransitionCriteria;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={CasMultifactorAuthenticationWebflowConfiguration.class, RadiusConfiguration.class, CasCoreConfiguration.class, CasCoreUtilConfiguration.class, RefreshAutoConfiguration.class})
@TestPropertySource(properties={"cas.authn.radius.client.sharedSecret=NoSecret", "cas.authn.radius.client.inetAddress=localhost,localguest", "cas.authn.mfa.radius.id=mfa-dummy"})
@Tag(value="Radius")
public class RadiusConfigurationTests {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="radiusConfiguration")
    private RadiusConfiguration radiusConfiguration;
    @Autowired
    @Qualifier(value="radiusAccessChallengedAuthenticationWebflowEventResolver")
    private CasWebflowEventResolver radiusAccessChallengedAuthenticationWebflowEventResolver;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @Test
    public void emptyAddress() {
        RadiusClientProperties clientProperties = new RadiusClientProperties();
        clientProperties.setInetAddress("  ");
        Set ips = RadiusConfiguration.getClientIps((RadiusClientProperties)clientProperties);
        Assertions.assertEquals((int)0, (int)ips.size());
    }

    @Test
    public void someAddressesWithSpaces() {
        RadiusClientProperties clientProperties = new RadiusClientProperties();
        clientProperties.setInetAddress("localhost,  localguest  ");
        Set ips = RadiusConfiguration.getClientIps((RadiusClientProperties)clientProperties);
        Assertions.assertEquals((int)2, (int)ips.size());
        Assertions.assertTrue((boolean)ips.contains("localhost"));
        Assertions.assertTrue((boolean)ips.contains("localguest"));
    }

    @Test
    public void radiusServer() {
        Assertions.assertNotNull((Object)this.radiusConfiguration.radiusServer());
    }

    @Test
    public void radiusServers() {
        Assertions.assertEquals((Object)"localhost,localguest", (Object)this.casProperties.getAuthn().getRadius().getClient().getInetAddress());
        List servers = this.radiusConfiguration.radiusServers();
        Assertions.assertNotNull((Object)servers);
        Assertions.assertEquals((int)2, (int)servers.size());
    }

    @Test
    public void verifyAccessChallengedWebflowEventResolver() {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        Set result = this.radiusAccessChallengedAuthenticationWebflowEventResolver.resolve((RequestContext)context);
        Assertions.assertNull((Object)result);
        Principal principal = CoreAuthenticationTestUtils.getPrincipal((String)"casuser", (Map)CollectionUtils.wrap((String)"Reply-Message", (Object)"Reply-Back", (String)"State", (Object)"State".getBytes(StandardCharsets.UTF_8)));
        WebUtils.putAuthentication((Authentication)CoreAuthenticationTestUtils.getAuthentication((Principal)principal), (RequestContext)context);
        TestMultifactorAuthenticationProvider.registerProviderIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        DefaultTargetStateResolver targetResolver = new DefaultTargetStateResolver("mfa-dummy");
        Transition transition = new Transition((TransitionCriteria)new DefaultTransitionCriteria((Expression)new LiteralExpression("mfa-dummy")), (TargetStateResolver)targetResolver);
        context.getRootFlow().getGlobalTransitionSet().add(transition);
        result = this.radiusAccessChallengedAuthenticationWebflowEventResolver.resolve((RequestContext)context);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"mfa-dummy", (Object)((Event)result.iterator().next()).getId());
    }
}

