/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.adaptors.radius.RadiusClientFactory;
import org.apereo.cas.adaptors.radius.RadiusProtocol;
import org.apereo.cas.adaptors.radius.RadiusServer;
import org.apereo.cas.adaptors.radius.authentication.handler.support.RadiusAuthenticationHandler;
import org.apereo.cas.adaptors.radius.server.AbstractRadiusServer;
import org.apereo.cas.adaptors.radius.server.NonBlockingRadiusServer;
import org.apereo.cas.adaptors.radius.web.flow.RadiusAccessChallengedAuthenticationWebflowEventResolver;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.authentication.support.password.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusServerProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;

@Configuration(value="radiusConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RadiusConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ObjectProvider<ServicesManager> servicesManager;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private ObjectProvider<CentralAuthenticationService> centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private ObjectProvider<TicketRegistrySupport> ticketRegistrySupport;
    @Autowired
    @Qualifier(value="multifactorAuthenticationProviderSelector")
    private ObjectProvider<MultifactorAuthenticationProviderSelector> multifactorAuthenticationProviderSelector;
    @Autowired
    @Qualifier(value="authenticationServiceSelectionPlan")
    private ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private ObjectProvider<CookieGenerator> warnCookieGenerator;
    @Autowired
    @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver")
    private ObjectProvider<CasDelegatingWebflowEventResolver> initialAuthenticationAttemptWebflowEventResolver;

    public static Set<String> getClientIps(RadiusClientProperties client) {
        return StringUtils.commaDelimitedListToSet((String)StringUtils.trimAllWhitespace((String)client.getInetAddress()));
    }

    @ConditionalOnMissingBean(name={"radiusPrincipalFactory"})
    @Bean
    public PrincipalFactory radiusPrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @RefreshScope
    @Bean
    public AbstractRadiusServer radiusServer() {
        RadiusProperties radius = this.casProperties.getAuthn().getRadius();
        RadiusClientProperties client = radius.getClient();
        RadiusServerProperties server = radius.getServer();
        Set<String> ips = RadiusConfiguration.getClientIps(client);
        return this.getSingleRadiusServer(client, server, ips.iterator().next());
    }

    @RefreshScope
    @Bean
    public List<RadiusServer> radiusServers() {
        RadiusProperties radius = this.casProperties.getAuthn().getRadius();
        RadiusClientProperties client = radius.getClient();
        RadiusServerProperties server = radius.getServer();
        Set<String> ips = RadiusConfiguration.getClientIps(radius.getClient());
        return ips.stream().map(ip -> this.getSingleRadiusServer(client, server, (String)ip)).collect(Collectors.toList());
    }

    @ConditionalOnMissingBean(name={"radiusAuthenticationHandler"})
    @Bean
    public AuthenticationHandler radiusAuthenticationHandler() {
        RadiusProperties radius = this.casProperties.getAuthn().getRadius();
        RadiusAuthenticationHandler h = new RadiusAuthenticationHandler(radius.getName(), (ServicesManager)this.servicesManager.getIfAvailable(), this.radiusPrincipalFactory(), this.radiusServers(), radius.isFailoverOnException(), radius.isFailoverOnAuthenticationFailure());
        h.setPasswordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)radius.getPasswordEncoder()));
        h.setPrincipalNameTransformer(PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)radius.getPrincipalTransformation()));
        h.setPasswordPolicyConfiguration(this.radiusPasswordPolicyConfiguration());
        return h;
    }

    @ConditionalOnMissingBean(name={"radiusAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    public AuthenticationEventExecutionPlanConfigurer radiusAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            Set<String> ips = RadiusConfiguration.getClientIps(this.casProperties.getAuthn().getRadius().getClient());
            if (!ips.isEmpty()) {
                plan.registerAuthenticationHandler(this.radiusAuthenticationHandler());
            } else {
                LOGGER.warn("No RADIUS address is defined. RADIUS support will be disabled.");
            }
        };
    }

    @ConditionalOnMissingBean(name={"radiusPasswordPolicyConfiguration"})
    @Bean
    public PasswordPolicyConfiguration radiusPasswordPolicyConfiguration() {
        return new PasswordPolicyConfiguration();
    }

    @RefreshScope
    @Bean
    public CasWebflowEventResolver radiusAccessChallengedAuthenticationWebflowEventResolver() {
        RadiusAccessChallengedAuthenticationWebflowEventResolver r = new RadiusAccessChallengedAuthenticationWebflowEventResolver((AuthenticationSystemSupport)this.authenticationSystemSupport.getIfAvailable(), (CentralAuthenticationService)this.centralAuthenticationService.getIfAvailable(), (ServicesManager)this.servicesManager.getIfAvailable(), (TicketRegistrySupport)this.ticketRegistrySupport.getIfAvailable(), (CookieGenerator)this.warnCookieGenerator.getIfAvailable(), (AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getIfAvailable(), (MultifactorAuthenticationProviderSelector)this.multifactorAuthenticationProviderSelector.getIfAvailable(), this.casProperties.getAuthn().getMfa().getRadius().getId());
        LOGGER.debug("Activating MFA event resolver based on RADIUS...");
        ((CasDelegatingWebflowEventResolver)this.initialAuthenticationAttemptWebflowEventResolver.getIfAvailable()).addDelegate((CasWebflowEventResolver)r);
        return r;
    }

    private AbstractRadiusServer getSingleRadiusServer(RadiusClientProperties client, RadiusServerProperties server, String clientInetAddress) {
        RadiusClientFactory factory = new RadiusClientFactory(client.getAccountingPort(), client.getAuthenticationPort(), client.getSocketTimeout(), clientInetAddress, client.getSharedSecret());
        RadiusProtocol protocol = RadiusProtocol.valueOf((String)server.getProtocol());
        return new NonBlockingRadiusServer(protocol, factory, server.getRetries(), server.getNasIpAddress(), server.getNasIpv6Address(), server.getNasPort(), server.getNasPortId(), server.getNasIdentifier(), server.getNasRealPort(), (long)server.getNasPortType());
    }
}

