/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.RadiusConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.radius.RadiusClientProperties;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={CasCoreServicesConfiguration.class, CasCoreWebflowConfiguration.class, RadiusConfiguration.class, RefreshAutoConfiguration.class})
@TestPropertySource(locations={"classpath:/radius2.properties"})
public class RadiusConfigurationTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RadiusConfigurationTests.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="radiusConfiguration")
    private RadiusConfiguration radiusConfiguration;

    @Test
    public void emptyAddress() {
        RadiusClientProperties clientProperties = new RadiusClientProperties();
        clientProperties.setInetAddress("  ");
        Set ips = RadiusConfiguration.getClientIps((RadiusClientProperties)clientProperties);
        Assert.assertEquals((long)0L, (long)ips.size());
    }

    @Test
    public void someAddressesWithSpaces() {
        RadiusClientProperties clientProperties = new RadiusClientProperties();
        clientProperties.setInetAddress("localhost,  localguest  ");
        Set ips = RadiusConfiguration.getClientIps((RadiusClientProperties)clientProperties);
        Assert.assertEquals((long)2L, (long)ips.size());
        Assert.assertTrue((boolean)ips.contains("localhost"));
        Assert.assertTrue((boolean)ips.contains("localguest"));
    }

    @Test
    public void radiusServer() {
        Assert.assertNotNull((Object)this.radiusConfiguration.radiusServer());
    }

    @Test
    public void radiusServers() {
        Assert.assertEquals((Object)"localhost,localguest", (Object)this.casProperties.getAuthn().getRadius().getClient().getInetAddress());
        List servers = this.radiusConfiguration.radiusServers();
        Assert.assertNotNull((Object)servers);
        Assert.assertEquals((long)2L, (long)servers.size());
    }
}

